/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.liftweb.common.Box;
import net.liftweb.common.Empty$;
import net.liftweb.common.Failure;
import net.liftweb.common.Full;
import net.liftweb.common.Logger;
import net.liftweb.common.Logger$;
import net.liftweb.util.ControlHelpers;
import net.liftweb.util.TimeHelpers;
import net.liftweb.util.TimeHelpers$;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class TimeHelpers$class {
    public static final Logger net$liftweb$util$TimeHelpers$$logger(TimeHelpers $this) {
        return Logger$.MODULE$.apply(TimeHelpers.class);
    }

    public static TimeHelpers.TimeSpanBuilder longToTimeSpanBuilder(TimeHelpers $this, long in) {
        return new TimeHelpers.TimeSpanBuilder($this, in);
    }

    public static TimeHelpers.TimeSpanBuilder intToTimeSpanBuilder(TimeHelpers $this, int in) {
        return new TimeHelpers.TimeSpanBuilder($this, in);
    }

    public static TimeHelpers.TimeSpan longToTimeSpan(TimeHelpers $this, long in) {
        return $this.TimeSpan().apply(in);
    }

    public static TimeHelpers.TimeSpan intToTimeSpan(TimeHelpers $this, int in) {
        return $this.TimeSpan().apply(in);
    }

    public static final Period net$liftweb$util$TimeHelpers$$durToPeriod(TimeHelpers $this, Duration dur) {
        return dur.toPeriod(PeriodType.standard());
    }

    public static long nano(TimeHelpers $this) {
        return System.nanoTime();
    }

    public static long millis(TimeHelpers $this) {
        return System.currentTimeMillis();
    }

    public static long seconds(TimeHelpers $this, long in) {
        return in * 1000L;
    }

    public static long minutes(TimeHelpers $this, long in) {
        return $this.seconds(in) * 60L;
    }

    public static long hours(TimeHelpers $this, long in) {
        return $this.minutes(in) * 60L;
    }

    public static long days(TimeHelpers $this, long in) {
        return $this.hours(in) * 24L;
    }

    public static long weeks(TimeHelpers $this, long in) {
        return $this.days(in) * 7L;
    }

    public static TimeHelpers.DateExtension toDateExtension(TimeHelpers $this, Date d) {
        return new TimeHelpers.DateExtension($this, d);
    }

    public static TimeHelpers.CalendarExtension toCalendarExtension(TimeHelpers $this, Calendar c) {
        return new TimeHelpers.CalendarExtension($this, c);
    }

    public static Date now(TimeHelpers $this) {
        return new Date();
    }

    public static Calendar today(TimeHelpers $this) {
        return $this.toCalendarExtension(Calendar.getInstance()).noTime();
    }

    public static int currentYear(TimeHelpers $this) {
        return Calendar.getInstance().get(1);
    }

    public static Date timeNow(TimeHelpers $this) {
        return new Date();
    }

    public static Date dayNow(TimeHelpers $this) {
        return $this.intToTimeSpanBuilder(0).seconds().later().noTime();
    }

    public static Date time(TimeHelpers $this, long when) {
        return new Date(when);
    }

    public static int month(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(2);
    }

    public static int year(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(1);
    }

    public static int day(TimeHelpers $this, Date in) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in.getTime());
        return cal.get(5);
    }

    public static long millisToDays(TimeHelpers $this, long millis) {
        return millis / 86400000L;
    }

    public static long daysSinceEpoch(TimeHelpers $this) {
        return $this.millisToDays($this.millis());
    }

    public static Tuple2 calcTime(TimeHelpers $this, Function0 f) {
        long start = $this.millis();
        Object result = f.apply();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)($this.millis() - start)), result);
    }

    public static Object logTime(TimeHelpers $this, String msg$1, Function0 f) {
        Tuple2 tuple2 = $this.calcTime(f);
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            long time$1 = tuple22._1$mcJ$sp();
            Object ret = tuple22._2();
            $this.net$liftweb$util$TimeHelpers$$logger().info((Function0)new Serializable($this, msg$1, time$1){
                public static final long serialVersionUID;
                public final String msg$1;
                public final long time$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.msg$1).append((Object)" took ").append((Object)BoxesRunTime.boxToLong((long)this.time$1)).append((Object)" Milliseconds").toString();
                }
                {
                    this.msg$1 = string2;
                    this.time$1 = l;
                }
            });
            return ret;
        }
        throw new MatchError(tuple2);
    }

    public static Object logTime(TimeHelpers $this, Function0 f) {
        Tuple2 tuple2 = $this.calcTime(f);
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            long time$2 = tuple22._1$mcJ$sp();
            Tuple2 fret = (Tuple2)tuple22._2();
            Tuple2 tuple23 = fret;
            if (tuple23 != null) {
                Tuple2 tuple24 = new Tuple2(tuple23._1(), tuple23._2());
                String msg$2 = (String)tuple24._1();
                Object ret = tuple24._2();
                $this.net$liftweb$util$TimeHelpers$$logger().info((Function0)new Serializable($this, time$2, msg$2){
                    public static final long serialVersionUID;
                    public final long time$2;
                    public final String msg$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)this.msg$2).append((Object)" took ").append((Object)BoxesRunTime.boxToLong((long)this.time$2)).append((Object)" Milliseconds").toString();
                    }
                    {
                        this.time$2 = l;
                        this.msg$2 = string2;
                    }
                });
                return ret;
            }
            throw new MatchError((Object)tuple23);
        }
        throw new MatchError(tuple2);
    }

    public static SimpleDateFormat hourFormat(TimeHelpers $this) {
        return new SimpleDateFormat("HH:mm:ss");
    }

    public static String hourFormat(TimeHelpers $this, Date in) {
        return $this.hourFormat().format(in);
    }

    public static SimpleDateFormat dateFormatter(TimeHelpers $this) {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public static SimpleDateFormat timeFormatter(TimeHelpers $this) {
        return new SimpleDateFormat("HH:mm zzz");
    }

    public static String formattedDateNow(TimeHelpers $this) {
        return $this.dateFormatter().format($this.now());
    }

    public static String formattedTimeNow(TimeHelpers $this) {
        return $this.timeFormatter().format($this.now());
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleDateFormat internetDateFormatter(TimeHelpers $this) {
        void var1_1;
        SimpleDateFormat ret = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        ret.setTimeZone($this.utc());
        return var1_1;
    }

    public static Box boxParseInternetDate(TimeHelpers $this, String dateString$1) {
        return ((ControlHelpers)((Object)$this)).tryo(new Serializable($this, dateString$1){
            public static final long serialVersionUID;
            public final TimeHelpers $outer;
            public final String dateString$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Date apply() {
                return this.$outer.internetDateFormatter().parse(this.dateString$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dateString$1 = string2;
            }
        });
    }

    public static Date parseInternetDate(TimeHelpers $this, String dateString$2) {
        return (Date)((ControlHelpers)((Object)$this)).tryo(new Serializable($this, dateString$2){
            public static final long serialVersionUID;
            public final TimeHelpers $outer;
            public final String dateString$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Date apply() {
                return this.$outer.internetDateFormatter().parse(this.dateString$2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dateString$2 = string2;
            }
        }).openOr((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Date apply() {
                return new Date(0L);
            }
        });
    }

    public static String toInternetDate(TimeHelpers $this, Date in) {
        return $this.internetDateFormatter().format(in);
    }

    public static String toInternetDate(TimeHelpers $this, long in) {
        return $this.internetDateFormatter().format(new Date(in));
    }

    public static String nowAsInternetDate(TimeHelpers $this) {
        return $this.toInternetDate($this.millis());
    }

    /*
     * Unable to fully structure code
     */
    public static Box toDate(TimeHelpers $this, Object in$1) {
        try {
            block13: {
                block16: {
                    block15: {
                        block14: {
                            block12: {
                                var4_2 = in$1;
                                if (var4_2 != null) break block12;
                                v0 = Empty$.MODULE$;
                                break block13;
                            }
                            if (!(var4_2 instanceof Date)) break block14;
                            v0 = new Full((Object)((Date)var4_2));
                            break block13;
                        }
                        if (!(var4_2 instanceof Long)) break block15;
                        v0 = new Full((Object)new Date(BoxesRunTime.unboxToLong((Object)var4_2)));
                        break block13;
                    }
                    if (!(var4_2 instanceof Number)) break block16;
                    v0 = new Full((Object)new Date(((Number)var4_2).longValue()));
                    break block13;
                }
                v1 = Nil$.MODULE$;
                var5_3 = var4_2;
                if (!(v1 == null ? var5_3 != null : v1.equals(var5_3) == false)) ** GOTO lbl-1000
                v2 = Empty$.MODULE$;
                var6_4 = var4_2;
                if (!(v2 == null ? var6_4 != null : v2.equals(var6_4) == false)) ** GOTO lbl-1000
                v3 = None$.MODULE$;
                var7_5 = var4_2;
                if (!(v3 == null ? var7_5 != null : v3.equals(var7_5) == false) || var4_2 instanceof Failure) lbl-1000:
                // 3 sources

                {
                    v0 = Empty$.MODULE$;
                } else if (var4_2 instanceof Full) {
                    v0 = $this.toDate(((Full)var4_2).value());
                } else if (var4_2 instanceof Some) {
                    v0 = $this.toDate(((Some)var4_2).x());
                } else if (var4_2 instanceof .colon.colon) {
                    v0 = $this.toDate(((.colon.colon)var4_2).hd$1());
                } else if (var4_2 instanceof String) {
                    s$1 = var8_6 = (String)var4_2;
                    v0 = ((ControlHelpers)$this).tryo(new Serializable($this, s$1){
                        public static final long serialVersionUID;
                        public final TimeHelpers $outer;
                        public final String s$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Date apply() {
                            return this.$outer.internetDateFormatter().parse(this.s$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.s$1 = string2;
                        }
                    }).or((Function0)new Serializable($this, s$1){
                        public static final long serialVersionUID;
                        public final TimeHelpers $outer;
                        public final String s$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Box<Date> apply() {
                            return ((ControlHelpers)((Object)this.$outer)).tryo(new Serializable(this){
                                public static final long serialVersionUID;
                                public final TimeHelpers$.anonfun.toDate.2 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Date apply() {
                                    return this.$outer.$outer.dateFormatter().parse(this.$outer.s$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public TimeHelpers net$liftweb$util$TimeHelpers$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.s$1 = string2;
                        }
                    });
                } else {
                    v0 = $this.toDate(var4_2.toString());
                }
            }
            exceptionResult1 = v0;
        }
        catch (Throwable var3_9) {
            $this.net$liftweb$util$TimeHelpers$$logger().debug((Function0)new Serializable($this, in$1){
                public static final long serialVersionUID;
                public final Object in$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Error parsing date ").append(this.in$1).toString();
                }
                {
                    this.in$1 = object;
                }
            }, var3_9);
            exceptionResult1 = new Failure(new StringBuilder().append((Object)"Bad date: ").append(in$1).toString(), (Box)new Full((Object)var3_9), (Box)Empty$.MODULE$);
        }
        return var2_8;
    }

    public static void $init$(TimeHelpers $this) {
        $this.net$liftweb$util$TimeHelpers$_setter_$net$liftweb$util$TimeHelpers$$outer_$eq($this);
        $this.net$liftweb$util$TimeHelpers$_setter_$utc_$eq(TimeZone.getTimeZone("UTC"));
    }
}

