/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import net.liftweb.http.ContainerSerializer;
import org.joda.time.DateTime;
import scala.Serializable;
import scala.collection.immutable.List;

public final class ContainerSerializer$ {
    public static final ContainerSerializer$ MODULE$;
    private final ContainerSerializer<Object> objectSerializer;
    private final ContainerSerializer<Object> intSerializer;
    private final ContainerSerializer<Object> longSerializer;
    private final ContainerSerializer<Object> charSerializer;
    private final ContainerSerializer<Object> shortSerializer;
    private final ContainerSerializer<Object> byteSerializer;
    private final ContainerSerializer<Object> floatSerializer;
    private final ContainerSerializer<Object> doubleSerializer;
    private final ContainerSerializer<Object> booleanSerializer;
    private final ContainerSerializer<Date> dateSerializer;
    private final ContainerSerializer<String> stringSerializer;
    private final ContainerSerializer<DateTime> jodaDateSerializer;

    static {
        new ContainerSerializer$();
    }

    private <T> ContainerSerializer<T> buildSerializer() {
        return new ContainerSerializer<T>(){

            public byte[] serialize(T in2) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(in2);
                oos.flush();
                return bos.toByteArray();
            }

            public T deserialize(byte[] in2) {
                ByteArrayInputStream bis = new ByteArrayInputStream(in2);
                ObjectInputStream ois = new ObjectInputStream(bis);
                return (T)ois.readObject();
            }
        };
    }

    public ContainerSerializer<Object> objectSerializer() {
        return this.objectSerializer;
    }

    public ContainerSerializer<Object> intSerializer() {
        return this.intSerializer;
    }

    public ContainerSerializer<Object> longSerializer() {
        return this.longSerializer;
    }

    public ContainerSerializer<Object> charSerializer() {
        return this.charSerializer;
    }

    public ContainerSerializer<Object> shortSerializer() {
        return this.shortSerializer;
    }

    public ContainerSerializer<Object> byteSerializer() {
        return this.byteSerializer;
    }

    public ContainerSerializer<Object> floatSerializer() {
        return this.floatSerializer;
    }

    public ContainerSerializer<Object> doubleSerializer() {
        return this.doubleSerializer;
    }

    public ContainerSerializer<Object> booleanSerializer() {
        return this.booleanSerializer;
    }

    public ContainerSerializer<Date> dateSerializer() {
        return this.dateSerializer;
    }

    public ContainerSerializer<String> stringSerializer() {
        return this.stringSerializer;
    }

    public ContainerSerializer<DateTime> jodaDateSerializer() {
        return this.jodaDateSerializer;
    }

    public <T> ContainerSerializer<Object> arraySerializer(ContainerSerializer<T> tc) {
        return this.buildSerializer();
    }

    public <T> ContainerSerializer<List<T>> listSerializer(ContainerSerializer<T> tc) {
        return this.buildSerializer();
    }

    public <T extends Serializable> ContainerSerializer<T> anyRefSerializer() {
        return this.buildSerializer();
    }

    private ContainerSerializer$() {
        MODULE$ = this;
        this.objectSerializer = this.buildSerializer();
        this.intSerializer = this.buildSerializer();
        this.longSerializer = this.buildSerializer();
        this.charSerializer = this.buildSerializer();
        this.shortSerializer = this.buildSerializer();
        this.byteSerializer = this.buildSerializer();
        this.floatSerializer = this.buildSerializer();
        this.doubleSerializer = this.buildSerializer();
        this.booleanSerializer = this.buildSerializer();
        this.dateSerializer = this.buildSerializer();
        this.stringSerializer = this.buildSerializer();
        this.jodaDateSerializer = this.buildSerializer();
    }
}

