/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.http.provider.encoder;

import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.liftweb.common.Box$;
import net.liftweb.http.provider.HTTPCookie;
import net.liftweb.http.provider.SameSite$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class CookieEncoder$ {
    public static final CookieEncoder$ MODULE$;
    private final BitSet VALID_COOKIE_NAME_OCTETS;
    private final BitSet VALID_COOKIE_VALUE_OCTETS;
    private final BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS;
    private final String net$liftweb$http$provider$encoder$CookieEncoder$$PATH;
    private final String net$liftweb$http$provider$encoder$CookieEncoder$$EXPIRES;
    private final String net$liftweb$http$provider$encoder$CookieEncoder$$MAX_AGE;
    private final String net$liftweb$http$provider$encoder$CookieEncoder$$DOMAIN;
    private final String net$liftweb$http$provider$encoder$CookieEncoder$$SECURE;
    private final String net$liftweb$http$provider$encoder$CookieEncoder$$HTTPONLY;
    private final String net$liftweb$http$provider$encoder$CookieEncoder$$SAMESITE;
    private final String[] DAY_OF_WEEK_TO_SHORT_NAME;
    private final String[] CALENDAR_MONTH_TO_SHORT_NAME;

    static {
        new CookieEncoder$();
    }

    private BitSet VALID_COOKIE_NAME_OCTETS() {
        return this.VALID_COOKIE_NAME_OCTETS;
    }

    private BitSet VALID_COOKIE_VALUE_OCTETS() {
        return this.VALID_COOKIE_VALUE_OCTETS;
    }

    private BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS() {
        return this.VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS;
    }

    public String net$liftweb$http$provider$encoder$CookieEncoder$$PATH() {
        return this.net$liftweb$http$provider$encoder$CookieEncoder$$PATH;
    }

    public String net$liftweb$http$provider$encoder$CookieEncoder$$EXPIRES() {
        return this.net$liftweb$http$provider$encoder$CookieEncoder$$EXPIRES;
    }

    public String net$liftweb$http$provider$encoder$CookieEncoder$$MAX_AGE() {
        return this.net$liftweb$http$provider$encoder$CookieEncoder$$MAX_AGE;
    }

    public String net$liftweb$http$provider$encoder$CookieEncoder$$DOMAIN() {
        return this.net$liftweb$http$provider$encoder$CookieEncoder$$DOMAIN;
    }

    public String net$liftweb$http$provider$encoder$CookieEncoder$$SECURE() {
        return this.net$liftweb$http$provider$encoder$CookieEncoder$$SECURE;
    }

    public String net$liftweb$http$provider$encoder$CookieEncoder$$HTTPONLY() {
        return this.net$liftweb$http$provider$encoder$CookieEncoder$$HTTPONLY;
    }

    public String net$liftweb$http$provider$encoder$CookieEncoder$$SAMESITE() {
        return this.net$liftweb$http$provider$encoder$CookieEncoder$$SAMESITE;
    }

    private String[] DAY_OF_WEEK_TO_SHORT_NAME() {
        return this.DAY_OF_WEEK_TO_SHORT_NAME;
    }

    private String[] CALENDAR_MONTH_TO_SHORT_NAME() {
        return this.CALENDAR_MONTH_TO_SHORT_NAME;
    }

    public String encode(HTTPCookie cookie) {
        String name2 = cookie.name();
        String value = (String)Box$.MODULE$.box2Option(cookie.value()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        boolean skipValidation = this.isOldVersionCookie(cookie);
        if (!skipValidation) {
            this.validateCookie(name2, value);
        }
        StringBuilder buf = new StringBuilder();
        this.net$liftweb$http$provider$encoder$CookieEncoder$$add(buf, name2, value);
        cookie.maxAge().foreach((Function1)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final StringBuilder buf$1;

            public final StringBuilder apply(int maxAge) {
                CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$add(this.buf$1, CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$MAX_AGE(), maxAge);
                Date expires = new Date((long)(maxAge * 1000) + System.currentTimeMillis());
                this.buf$1.append(CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$EXPIRES());
                this.buf$1.append('=');
                CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$appendDate(expires, this.buf$1);
                this.buf$1.append(';');
                return this.buf$1.append(' ');
            }
            {
                this.buf$1 = buf$1;
            }
        });
        cookie.path().foreach((Function1)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final StringBuilder buf$1;

            public final StringBuilder apply(String path2) {
                return CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$add(this.buf$1, CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$PATH(), path2);
            }
            {
                this.buf$1 = buf$1;
            }
        });
        cookie.domain().foreach((Function1)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final StringBuilder buf$1;

            public final StringBuilder apply(String domain) {
                return CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$add(this.buf$1, CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$DOMAIN(), domain);
            }
            {
                this.buf$1 = buf$1;
            }
        });
        cookie.secure_$qmark().foreach((Function1)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final StringBuilder buf$1;

            public final Object apply(boolean isSecure) {
                return isSecure ? CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$add(this.buf$1, CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$SECURE()) : BoxedUnit.UNIT;
            }
            {
                this.buf$1 = buf$1;
            }
        });
        cookie.httpOnly().foreach((Function1)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final StringBuilder buf$1;

            public final Object apply(boolean isHttpOnly) {
                return isHttpOnly ? CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$add(this.buf$1, CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$HTTPONLY()) : BoxedUnit.UNIT;
            }
            {
                this.buf$1 = buf$1;
            }
        });
        cookie.sameSite().foreach((Function1)new Serializable(buf){
            public static final long serialVersionUID = 0L;
            private final StringBuilder buf$1;

            public final StringBuilder apply(Enumeration.Value x0$1) {
                Enumeration.Value value;
                block5: {
                    StringBuilder stringBuilder;
                    block3: {
                        block4: {
                            block2: {
                                value = x0$1;
                                Enumeration.Value value2 = SameSite$.MODULE$.LAX();
                                Enumeration.Value value3 = value;
                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                stringBuilder = CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$add(this.buf$1, CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$SAMESITE(), "Lax");
                                break block3;
                            }
                            Enumeration.Value value4 = SameSite$.MODULE$.STRICT();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                            stringBuilder = CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$add(this.buf$1, CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$SAMESITE(), "Strict");
                            break block3;
                        }
                        Enumeration.Value value6 = SameSite$.MODULE$.NONE();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                        stringBuilder = CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$add(this.buf$1, CookieEncoder$.MODULE$.net$liftweb$http$provider$encoder$CookieEncoder$$SAMESITE(), "None");
                    }
                    return stringBuilder;
                }
                throw new MatchError((Object)value);
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return this.stripTrailingSeparator(buf);
    }

    private void validateCookie(String name2, String value) {
        int posFirstInvalidCookieNameOctet = this.firstInvalidCookieNameOctet(name2);
        if (posFirstInvalidCookieNameOctet >= 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cookie name contains an invalid char: ").append((Object)BoxesRunTime.boxToCharacter((char)name2.charAt(posFirstInvalidCookieNameOctet))).toString());
        }
        CharSequence unwrappedValue = this.unwrapValue(value);
        if (unwrappedValue == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cookie value wrapping quotes are not balanced: ").append((Object)value).toString());
        }
        int postFirstInvalidCookieValueOctet = this.firstInvalidCookieValueOctet(unwrappedValue);
        if (postFirstInvalidCookieValueOctet >= 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cookie value contains an invalid char: ").append((Object)BoxesRunTime.boxToCharacter((char)unwrappedValue.charAt(postFirstInvalidCookieValueOctet))).toString());
        }
    }

    private boolean isOldVersionCookie(HTTPCookie cookie) {
        return BoxesRunTime.unboxToBoolean((Object)Box$.MODULE$.box2Option(cookie.version().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return x$1 == 0;
            }
        })).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    public StringBuilder net$liftweb$http$provider$encoder$CookieEncoder$$appendDate(Date date, StringBuilder sb) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(date);
        sb.append(this.DAY_OF_WEEK_TO_SHORT_NAME()[cal.get(7) - 1]).append(", ");
        this.appendZeroLeftPadded(cal.get(5), sb).append(' ');
        sb.append(this.CALENDAR_MONTH_TO_SHORT_NAME()[cal.get(2)]).append(' ');
        sb.append(cal.get(1)).append(' ');
        this.appendZeroLeftPadded(cal.get(11), sb).append(':');
        this.appendZeroLeftPadded(cal.get(12), sb).append(':');
        return this.appendZeroLeftPadded(cal.get(13), sb).append(" GMT");
    }

    private StringBuilder appendZeroLeftPadded(int value, StringBuilder sb) {
        Object object = value < 10 ? sb.append('0') : BoxedUnit.UNIT;
        return sb.append(value);
    }

    /*
     * WARNING - void declaration
     */
    private BitSet validCookieNameOctets() {
        void var1_1;
        BitSet bits = new BitSet();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(32), 127).foreach$mVc$sp((Function1)new Serializable(bits){
            public static final long serialVersionUID = 0L;
            private final BitSet bits$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.bits$1.set(x$1);
            }
            {
                this.bits$1 = bits$1;
            }
        });
        char[] separators = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};
        Predef$.MODULE$.charArrayOps(separators).foreach((Function1)new Serializable(bits){
            public static final long serialVersionUID = 0L;
            private final BitSet bits$1;

            public final void apply(char separator) {
                this.bits$1.set((int)separator, false);
            }
            {
                this.bits$1 = bits$1;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private BitSet validCookieValueOctets() {
        void var1_1;
        BitSet bits = new BitSet();
        bits.set(33);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(35), 43).foreach$mVc$sp((Function1)new Serializable(bits){
            public static final long serialVersionUID = 0L;
            private final BitSet bits$2;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.bits$2.set(x$1);
            }
            {
                this.bits$2 = bits$2;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(45), 58).foreach$mVc$sp((Function1)new Serializable(bits){
            public static final long serialVersionUID = 0L;
            private final BitSet bits$2;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.bits$2.set(x$1);
            }
            {
                this.bits$2 = bits$2;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(60), 91).foreach$mVc$sp((Function1)new Serializable(bits){
            public static final long serialVersionUID = 0L;
            private final BitSet bits$2;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.bits$2.set(x$1);
            }
            {
                this.bits$2 = bits$2;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(93), 126).foreach$mVc$sp((Function1)new Serializable(bits){
            public static final long serialVersionUID = 0L;
            private final BitSet bits$2;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.bits$2.set(x$1);
            }
            {
                this.bits$2 = bits$2;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private BitSet validCookieAttributeValueOctets() {
        void var1_1;
        BitSet bits = new BitSet();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(32), 127).foreach$mVc$sp((Function1)new Serializable(bits){
            public static final long serialVersionUID = 0L;
            private final BitSet bits$3;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.bits$3.set(x$1);
            }
            {
                this.bits$3 = bits$3;
            }
        });
        bits.set(59, false);
        return var1_1;
    }

    private String stripTrailingSeparator(StringBuilder buf) {
        if (Predef$.MODULE$.SeqCharSequence((IndexedSeq)buf).length() > 0) {
            buf.setLength(Predef$.MODULE$.SeqCharSequence((IndexedSeq)buf).length() - 2);
        }
        return buf.toString();
    }

    public StringBuilder net$liftweb$http$provider$encoder$CookieEncoder$$add(StringBuilder sb, String name2, long value) {
        sb.append(name2);
        sb.append('=');
        sb.append(value);
        sb.append(';');
        return sb.append(' ');
    }

    public StringBuilder net$liftweb$http$provider$encoder$CookieEncoder$$add(StringBuilder sb, String name2, String value) {
        sb.append(name2);
        sb.append('=');
        sb.append(value);
        sb.append(';');
        return sb.append(' ');
    }

    public StringBuilder net$liftweb$http$provider$encoder$CookieEncoder$$add(StringBuilder sb, String name2) {
        sb.append(name2);
        sb.append(';');
        return sb.append(' ');
    }

    private int firstInvalidCookieNameOctet(CharSequence cs) {
        return this.firstInvalidOctet(cs, this.VALID_COOKIE_NAME_OCTETS());
    }

    private int firstInvalidCookieValueOctet(CharSequence cs) {
        return this.firstInvalidOctet(cs, this.VALID_COOKIE_VALUE_OCTETS());
    }

    private int firstInvalidOctet(CharSequence cs, BitSet bits) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            int n;
            Object object = new Object();
            try {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cs.length()).foreach$mVc$sp((Function1)new Serializable(cs, bits, object){
                    public static final long serialVersionUID = 0L;
                    private final CharSequence cs$1;
                    private final BitSet bits$4;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int i2) {
                        this.apply$mcVI$sp(i2);
                    }

                    public void apply$mcVI$sp(int i2) {
                        char c = this.cs$1.charAt(i2);
                        if (this.bits$4.get(c)) {
                            return;
                        }
                        throw new NonLocalReturnControl.mcI.sp(this.nonLocalReturnKey1$1, i2);
                    }
                    {
                        this.cs$1 = cs$1;
                        this.bits$4 = bits$4;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                n = -1;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                n = nonLocalReturnControl2.value$mcI$sp();
            }
            return n;
        }
        throw nonLocalReturnControl2;
    }

    private CharSequence unwrapValue(CharSequence cs) {
        int len = cs.length();
        return len > 0 && cs.charAt(0) == '\"' ? (len >= 2 && cs.charAt(len - 1) == '\"' ? (len == 2 ? "" : cs.subSequence(1, len - 1)) : null) : cs;
    }

    private CookieEncoder$() {
        MODULE$ = this;
        this.VALID_COOKIE_NAME_OCTETS = this.validCookieNameOctets();
        this.VALID_COOKIE_VALUE_OCTETS = this.validCookieValueOctets();
        this.VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS = this.validCookieAttributeValueOctets();
        this.net$liftweb$http$provider$encoder$CookieEncoder$$PATH = "Path";
        this.net$liftweb$http$provider$encoder$CookieEncoder$$EXPIRES = "Expires";
        this.net$liftweb$http$provider$encoder$CookieEncoder$$MAX_AGE = "Max-Age";
        this.net$liftweb$http$provider$encoder$CookieEncoder$$DOMAIN = "Domain";
        this.net$liftweb$http$provider$encoder$CookieEncoder$$SECURE = "Secure";
        this.net$liftweb$http$provider$encoder$CookieEncoder$$HTTPONLY = "HTTPOnly";
        this.net$liftweb$http$provider$encoder$CookieEncoder$$SAMESITE = "SameSite";
        this.DAY_OF_WEEK_TO_SHORT_NAME = (String[])((Object[])new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"});
        this.CALENDAR_MONTH_TO_SHORT_NAME = (String[])((Object[])new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
    }
}

