/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import net.liftweb.http.ContainerSerializer;
import org.joda.time.DateTime;
import scala.collection.immutable.List;

public final class ContainerSerializer$ {
    public static final ContainerSerializer$ MODULE$ = new ContainerSerializer$();
    private static final ContainerSerializer<Object> objectSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Object> intSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Object> longSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Object> charSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Object> shortSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Object> byteSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Object> floatSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Object> doubleSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Object> booleanSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<Date> dateSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<String> stringSerializer = MODULE$.buildSerializer();
    private static final ContainerSerializer<DateTime> jodaDateSerializer = MODULE$.buildSerializer();

    private <T> ContainerSerializer<T> buildSerializer() {
        return new ContainerSerializer<T>(){

            public byte[] serialize(T in) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(in);
                oos.flush();
                return bos.toByteArray();
            }

            public T deserialize(byte[] in) {
                ByteArrayInputStream bis = new ByteArrayInputStream(in);
                ObjectInputStream ois = new ObjectInputStream(bis);
                return (T)ois.readObject();
            }
        };
    }

    public ContainerSerializer<Object> objectSerializer() {
        return objectSerializer;
    }

    public ContainerSerializer<Object> intSerializer() {
        return intSerializer;
    }

    public ContainerSerializer<Object> longSerializer() {
        return longSerializer;
    }

    public ContainerSerializer<Object> charSerializer() {
        return charSerializer;
    }

    public ContainerSerializer<Object> shortSerializer() {
        return shortSerializer;
    }

    public ContainerSerializer<Object> byteSerializer() {
        return byteSerializer;
    }

    public ContainerSerializer<Object> floatSerializer() {
        return floatSerializer;
    }

    public ContainerSerializer<Object> doubleSerializer() {
        return doubleSerializer;
    }

    public ContainerSerializer<Object> booleanSerializer() {
        return booleanSerializer;
    }

    public ContainerSerializer<Date> dateSerializer() {
        return dateSerializer;
    }

    public ContainerSerializer<String> stringSerializer() {
        return stringSerializer;
    }

    public ContainerSerializer<DateTime> jodaDateSerializer() {
        return jodaDateSerializer;
    }

    public <T> ContainerSerializer<Object> arraySerializer(ContainerSerializer<T> tc) {
        return this.buildSerializer();
    }

    public <T> ContainerSerializer<List<T>> listSerializer(ContainerSerializer<T> tc) {
        return this.buildSerializer();
    }

    public <T extends Serializable> ContainerSerializer<T> anyRefSerializer() {
        return this.buildSerializer();
    }

    private ContainerSerializer$() {
    }
}

