/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lightbody.bmp.proxy.error.ProxyError;
import net.lightbody.bmp.proxy.http.BadURIException;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import net.lightbody.bmp.proxy.http.BrowserMobHttpRequest;
import net.lightbody.bmp.proxy.http.BrowserMobHttpResponse;
import net.lightbody.bmp.proxy.http.RequestCallback;
import net.lightbody.bmp.proxy.jetty.http.EOFException;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpListener;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.HttpServer;
import net.lightbody.bmp.proxy.jetty.http.HttpTunnel;
import net.lightbody.bmp.proxy.jetty.http.SocketListener;
import net.lightbody.bmp.proxy.jetty.jetty.Server;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import net.lightbody.bmp.proxy.jetty.util.URI;
import net.lightbody.bmp.proxy.selenium.SeleniumProxyHandler;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserMobProxyHandler
extends SeleniumProxyHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserMobProxyHandler.class);
    private static final int HEADER_BUFFER_DEFAULT = 2;
    private Server jettyServer;
    private int headerBufferMultiplier = 2;
    private BrowserMobHttpClient httpClient;
    protected final Set<SeleniumProxyHandler.SslRelay> sslRelays = new HashSet<SeleniumProxyHandler.SslRelay>();

    public BrowserMobProxyHandler() {
        super(true, "", "", false, false);
        this.setShutdownLock(new Object());
        this.setTunnelTimeoutMs(300000);
    }

    @Override
    public void handleConnect(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        String altHost;
        String original;
        URI uri = request.getURI();
        String host = original = uri.toString();
        String port = null;
        int colon = original.indexOf(58);
        if (colon != -1) {
            host = original.substring(0, colon);
            port = original.substring(colon + 1);
        }
        if ((altHost = this.httpClient.remappedHost(host)) != null) {
            if (port != null) {
                uri.setURI(String.valueOf(altHost) + ":" + port);
            } else {
                uri.setURI(altHost);
            }
        }
        super.handleConnect(pathInContext, pathParams, request, response);
    }

    @Override
    protected void wireUpSslWithImpersonationCA(String host, SeleniumProxyHandler.SslRelay listener) {
        List<String> originalHosts = this.httpClient.originalHosts(host);
        if (originalHosts != null && !originalHosts.isEmpty()) {
            if (originalHosts.size() == 1) {
                host = originalHosts.get(0);
            } else {
                String first = originalHosts.get(0);
                host = "*" + first.substring(first.indexOf(46));
            }
        }
        super.wireUpSslWithImpersonationCA(host, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SeleniumProxyHandler.SslRelay getSslRelayOrCreateNew(URI uri, InetAddrPort addrPort, HttpServer server) throws Exception {
        SeleniumProxyHandler.SslRelay relay = super.getSslRelayOrCreateNew(uri, addrPort, server);
        relay.setNukeDirOrFile(null);
        Set<SeleniumProxyHandler.SslRelay> set = this.sslRelays;
        synchronized (set) {
            this.sslRelays.add(relay);
        }
        if (!relay.isStarted()) {
            server.addListener(relay);
            this.startRelayWithPortTollerance(server, relay, 1);
        }
        return relay;
    }

    private void startRelayWithPortTollerance(HttpServer server, SeleniumProxyHandler.SslRelay relay, int tries) throws Exception {
        if (tries >= 5) {
            throw new BindException("Unable to bind to several ports, most recently " + relay.getPort() + ". Giving up");
        }
        try {
            if (!server.isStarted()) {
                throw new RuntimeException("Can't start SslRelay: server is not started (perhaps it was just shut down?)");
            }
            relay.start();
        }
        catch (BindException e) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Unable to bind to port {}, going to try port {} now", new Object[]{relay.getPort(), relay.getPort() + 1, e});
            } else {
                LOG.info("Unable to bind to port {}, going to try port {} now", (Object)relay.getPort(), (Object)(relay.getPort() + 1));
            }
            relay.setPort(relay.getPort() + 1);
            this.startRelayWithPortTollerance(server, relay, tries + 1);
        }
    }

    @Override
    protected HttpTunnel newHttpTunnel(HttpRequest httpRequest, HttpResponse httpResponse, InetAddress inetAddress, int i, int i1) throws IOException {
        this.adjustListenerBuffers();
        return super.newHttpTunnel(httpRequest, httpResponse, inetAddress, i, i1);
    }

    @Override
    protected long proxyPlainTextRequest(final URL url, String pathInContext, String pathParams, HttpRequest request, final HttpResponse response) throws IOException {
        BrowserMobHttpRequest httpReq;
        block22: {
            String urlStr;
            block21: {
                block20: {
                    urlStr = url.toString();
                    if (urlStr.contains("/selenium-server/")) {
                        return super.proxyPlainTextRequest(url, pathInContext, pathParams, request, response);
                    }
                    if (!urlStr.startsWith("https://sb-ssl.google.com:443/safebrowsing") && !urlStr.startsWith("http://en-us.fxfeeds.mozilla.com/en-US/firefox/headlines.xml") && !urlStr.startsWith("http://fxfeeds.mozilla.com/firefox/headlines.xml") && !urlStr.startsWith("http://fxfeeds.mozilla.com/en-US/firefox/headlines.xml") && !urlStr.startsWith("http://newsrss.bbc.co.uk/rss/newsonline_world_edition/front_page/rss.xml")) break block20;
                    request.setHandled(true);
                    return -1L;
                }
                if (this.httpClient != null) break block21;
                request.setHandled(true);
                return -1L;
            }
            httpReq = null;
            if ("GET".equals(request.getMethod())) {
                httpReq = this.httpClient.newGet(urlStr, request);
                break block22;
            }
            if ("POST".equals(request.getMethod())) {
                httpReq = this.httpClient.newPost(urlStr, request);
                break block22;
            }
            if ("PUT".equals(request.getMethod())) {
                httpReq = this.httpClient.newPut(urlStr, request);
                break block22;
            }
            if ("DELETE".equals(request.getMethod())) {
                httpReq = this.httpClient.newDelete(urlStr, request);
                break block22;
            }
            if ("OPTIONS".equals(request.getMethod())) {
                httpReq = this.httpClient.newOptions(urlStr, request);
                break block22;
            }
            if ("HEAD".equals(request.getMethod())) {
                httpReq = this.httpClient.newHead(urlStr, request);
                break block22;
            }
            if ("PATCH".equals(request.getMethod())) {
                httpReq = this.httpClient.newPatch(urlStr, request);
                break block22;
            }
            if ("TRACE".equals(request.getMethod())) {
                httpReq = this.httpClient.newTrace(urlStr, request);
                break block22;
            }
            LOG.warn("Unexpected request method {}, giving up", (Object)request.getMethod());
            request.setHandled(true);
            return -1L;
        }
        try {
            boolean isGet = "GET".equals(request.getMethod());
            boolean hasContent = false;
            Enumeration enm = request.getFieldNames();
            long contentLength = 0L;
            while (enm.hasMoreElements()) {
                String hdr = (String)enm.nextElement();
                if (!isGet && "Content-Type".equals(hdr)) {
                    hasContent = true;
                }
                Enumeration vals = request.getFieldValues(hdr);
                while (vals.hasMoreElements()) {
                    String val = (String)vals.nextElement();
                    if (val == null) continue;
                    if (!isGet && "Content-Length".equals(hdr) && (contentLength = Long.parseLong(request.getField(hdr))) > 0L) {
                        hasContent = true;
                    }
                    if (this._DontProxyHeaders.containsKey(hdr)) continue;
                    httpReq.addRequestHeader(hdr, val);
                }
            }
            InputStream in = request.getInputStream();
            if (hasContent) {
                httpReq.setRequestInputStream(in, contentLength);
            }
            httpReq.setOutputStream(response.getOutputStream());
            httpReq.setRequestCallback(new RequestCallback(){

                @Override
                public void handleStatusLine(StatusLine statusLine) {
                    response.setStatus(statusLine.getStatusCode());
                    response.setReason(statusLine.getReasonPhrase());
                }

                @Override
                public void handleHeaders(Header[] headers) {
                    Header[] headerArray = headers;
                    int n = headers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Header header = headerArray[n2];
                        if (this.reportHeader(header)) {
                            response.addField(header.getName(), header.getValue());
                        }
                        ++n2;
                    }
                }

                @Override
                public boolean reportHeader(Header header) {
                    return !BrowserMobProxyHandler.this._DontProxyHeaders.containsKey(header.getName()) && !BrowserMobProxyHandler.this._ProxyAuthHeaders.containsKey(header.getName());
                }

                @Override
                public void reportError(Exception e) {
                    BrowserMobProxyHandler.reportError(e, url, response);
                }
            });
            BrowserMobHttpResponse httpRes = httpReq.execute();
            request.setHandled(true);
            return httpRes.getEntry().getResponse().getBodySize();
        }
        catch (BadURIException e) {
            LOG.info("Encountered bad URI exception while proxying " + url, (Throwable)e);
            BrowserMobProxyHandler.reportError(e, url, response);
            return -1L;
        }
        catch (RuntimeException e) {
            LOG.info("Exception while proxying " + url, (Throwable)e);
            BrowserMobProxyHandler.reportError(e, url, response);
            return -1L;
        }
    }

    private static void reportError(Exception e, URL url, HttpResponse response) {
        boolean timeout = false;
        ProxyError error = ProxyError.GENERIC;
        if (e instanceof UnknownHostException) {
            error = ProxyError.DNS_NOT_FOUND;
        } else if (e instanceof ConnectException) {
            error = ProxyError.CONN_FAILURE;
        } else if (e instanceof ConnectTimeoutException) {
            timeout = true;
            error = ProxyError.NET_TIMEOUT;
        } else if (e instanceof NoHttpResponseException) {
            error = ProxyError.NET_RESET;
        } else if (e instanceof EOFException) {
            error = ProxyError.NET_INTERRUPT;
        } else if (e instanceof IllegalArgumentException && e.getMessage().startsWith("Host name may not be null")) {
            error = ProxyError.DNS_NOT_FOUND;
        } else if (e instanceof BadURIException) {
            error = ProxyError.MALFORMED_URI;
        }
        String text = error.getHtml(url.toString());
        try {
            if (timeout) {
                response.setStatus(504);
            } else {
                response.setStatus(502);
            }
            response.setContentLength(text.length());
            response.getOutputStream().write(text.getBytes());
        }
        catch (IOException e1) {
            LOG.warn("IOException while trying to report an HTTP error", (Throwable)e1);
        }
    }

    public void autoBasicAuthorization(String domain, String username, String password) {
        this.httpClient.autoBasicAuthorization(domain, username, password);
    }

    public void rewriteUrl(String match, String replace) {
        this.httpClient.rewriteUrl(match, replace);
    }

    public void remapHost(String source, String target) {
        this.httpClient.remapHost(source, target);
    }

    public void setJettyServer(Server jettyServer) {
        this.jettyServer = jettyServer;
    }

    public void adjustListenerBuffers(int headerBufferMultiplier) {
        if (headerBufferMultiplier > 10) {
            headerBufferMultiplier = 10;
        }
        this.headerBufferMultiplier = headerBufferMultiplier;
        this.adjustListenerBuffers();
    }

    public void resetListenerBuffers() {
        this.headerBufferMultiplier = 2;
        this.adjustListenerBuffers();
    }

    public void adjustListenerBuffers() {
        HttpListener[] listeners;
        HttpListener[] httpListenerArray = listeners = this.jettyServer.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            HttpListener listener = httpListenerArray[n2];
            if (listener instanceof SocketListener) {
                SocketListener sl = (SocketListener)listener;
                if (sl.getBufferReserve() != 512 * this.headerBufferMultiplier) {
                    sl.setBufferReserve(512 * this.headerBufferMultiplier);
                }
                if (sl.getBufferSize() != 8192 * this.headerBufferMultiplier) {
                    sl.setBufferSize(8192 * this.headerBufferMultiplier);
                }
            }
            ++n2;
        }
    }

    public void setHttpClient(BrowserMobHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Set<SeleniumProxyHandler.SslRelay> set = this.sslRelays;
        synchronized (set) {
            for (SeleniumProxyHandler.SslRelay relay : this.sslRelays) {
                if (relay.getHttpServer() == null || !relay.isStarted()) continue;
                relay.getHttpServer().removeListener(relay);
            }
            this.sslRelays.clear();
        }
    }
}

