/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.error;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorUtil {
    private static final Logger log = LoggerFactory.getLogger(ErrorUtil.class);
    private static final String ERROR_HTML_CLASSPATH_LOCATION = "/net/lightbody/bmp/html/error.html";
    private static final String DEFAULT_ERROR_HTML = "<html><head><title>%s</title></head><body><h1>%s</h1><p>%s</p><p>%s</p></body>";
    private static volatile String errorHtml;

    public static String getErrorHtml() {
        if (errorHtml == null) {
            ErrorUtil.loadErrorHtml();
        }
        return errorHtml;
    }

    private static synchronized void loadErrorHtml() {
        if (errorHtml == null) {
            try {
                Throwable throwable = null;
                Object var1_4 = null;
                try (InputStream errorHtmlStream = ErrorUtil.class.getResourceAsStream(ERROR_HTML_CLASSPATH_LOCATION);){
                    if (errorHtmlStream != null) {
                        errorHtml = IOUtils.toString((InputStream)errorHtmlStream);
                    } else {
                        log.error("Could not load error.html file. Defaulting to minimalist error page HTML.");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.warn("Exception while closing error.html stream", (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error("Could not load error.html file. Defaulting to minimalist error page HTML.", (Throwable)e);
            }
            if (errorHtml == null) {
                errorHtml = DEFAULT_ERROR_HTML;
            }
        }
    }
}

