/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import com.google.common.io.BaseEncoding;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import net.lightbody.bmp.proxy.http.BrowserMobHttpResponse;
import net.lightbody.bmp.proxy.http.RepeatableInputStreamRequestEntity;
import net.lightbody.bmp.proxy.http.RequestCallback;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.util.ClonedInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserMobHttpRequest {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserMobHttpRequest.class);
    private HttpRequestBase method;
    private BrowserMobHttpClient client;
    private int expectedStatusCode;
    private List<NameValuePair> nvps = new ArrayList<NameValuePair>();
    private StringEntity stringEntity;
    private ByteArrayEntity byteArrayEntity;
    private RepeatableInputStreamRequestEntity inputStreamEntity;
    private MultipartEntity multipartEntity;
    private OutputStream outputStream;
    private RequestCallback requestCallback;
    private boolean collectAdditionalInfo;
    private HttpRequest proxyRequest;
    private ByteArrayOutputStream copy;
    private String expectedLocation;
    private boolean multiPart;

    protected BrowserMobHttpRequest(HttpRequestBase method, BrowserMobHttpClient client, int expectedStatusCode, boolean collectAdditionalInfo, HttpRequest proxyRequest) {
        this.method = method;
        this.client = client;
        this.expectedStatusCode = expectedStatusCode;
        this.collectAdditionalInfo = collectAdditionalInfo;
        this.proxyRequest = proxyRequest;
    }

    public RepeatableInputStreamRequestEntity getInputStreamEntity() {
        return this.inputStreamEntity;
    }

    public String getExpectedLocation() {
        return this.expectedLocation;
    }

    public void setExpectedLocation(String location) {
        this.expectedLocation = location;
    }

    public void addRequestHeader(String key, String value) {
        this.method.addHeader(key, value);
    }

    public void addRequestParameter(String key, String value) {
        this.nvps.add((NameValuePair)new BasicNameValuePair(key, value));
    }

    public void setRequestBody(String body, String contentType, String charSet) {
        try {
            this.stringEntity = new StringEntity(body, ContentType.create((String)contentType, (String)charSet));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            this.stringEntity = new StringEntity(body, ContentType.create((String)contentType, null));
        }
    }

    public void setRequestBody(String body) {
        this.setRequestBody(body, null, "UTF-8");
    }

    public void setRequestBodyAsBase64EncodedBytes(String bodyBase64Encoded) {
        this.byteArrayEntity = new ByteArrayEntity(BaseEncoding.base64().decode((CharSequence)bodyBase64Encoded));
    }

    public void setRequestInputStream(InputStream is, long length) {
        if (this.collectAdditionalInfo) {
            ClonedInputStream cis = new ClonedInputStream(is);
            is = cis;
            this.copy = cis.getOutput();
        }
        this.inputStreamEntity = new RepeatableInputStreamRequestEntity(is, length);
    }

    public HttpRequestBase getMethod() {
        return this.method;
    }

    public HttpRequest getProxyRequest() {
        return this.proxyRequest;
    }

    public void makeMultiPart() {
        if (!this.multiPart) {
            this.multiPart = true;
            this.multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        }
    }

    public BrowserMobHttpResponse execute() {
        block14: {
            if (this.method instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase enclodingRequest = (HttpEntityEnclosingRequestBase)this.method;
                if (!this.nvps.isEmpty()) {
                    try {
                        if (!this.multiPart) {
                            enclodingRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(this.nvps, StandardCharsets.UTF_8));
                            break block14;
                        }
                        for (NameValuePair nvp : this.nvps) {
                            this.multipartEntity.addPart(nvp.getName(), (ContentBody)new StringBody(nvp.getValue()));
                        }
                        enclodingRequest.setEntity((HttpEntity)this.multipartEntity);
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error("Could not find UTF-8 encoding, something is really wrong", (Throwable)e);
                    }
                } else if (this.multipartEntity != null) {
                    enclodingRequest.setEntity((HttpEntity)this.multipartEntity);
                } else if (this.byteArrayEntity != null) {
                    enclodingRequest.setEntity((HttpEntity)this.byteArrayEntity);
                } else if (this.stringEntity != null) {
                    enclodingRequest.setEntity((HttpEntity)this.stringEntity);
                } else if (this.inputStreamEntity != null) {
                    enclodingRequest.setEntity((HttpEntity)this.inputStreamEntity);
                }
            }
        }
        return this.client.execute(this);
    }

    public int getExpectedStatusCode() {
        return this.expectedStatusCode;
    }

    public void setExpectedStatusCode(int expectedStatusCode) {
        this.expectedStatusCode = expectedStatusCode;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public RequestCallback getRequestCallback() {
        return this.requestCallback;
    }

    public void setRequestCallback(RequestCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public ByteArrayOutputStream getCopy() {
        return this.copy;
    }
}

