/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.html;

import java.util.Enumeration;
import net.lightbody.bmp.proxy.jetty.html.Block;
import net.lightbody.bmp.proxy.jetty.html.Composite;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import org.apache.commons.logging.Log;

public class Select
extends Block {
    private static Log log = LogFactory.getLog(Select.class);

    public Select(String name, boolean multiple) {
        super("select");
        this.attribute("name", name);
        if (multiple) {
            this.attribute("multiple");
        }
    }

    public Select(String name, boolean multiple, String[] options) {
        this(name, multiple);
        int i = 0;
        while (i < options.length) {
            this.add(options[i]);
            ++i;
        }
    }

    public Select setSize(int size) {
        this.size(size);
        return this;
    }

    public Select add(Enumeration e) {
        while (e.hasMoreElements()) {
            this.add(e.nextElement().toString());
        }
        return this;
    }

    @Override
    public Composite add(Object o) {
        if (o instanceof Enumeration) {
            this.add((Enumeration)o);
        } else {
            super.add("<option>");
            super.add(o);
        }
        return this;
    }

    public Select add(Object o, boolean selected) {
        if (selected) {
            super.add("<option selected>");
        } else {
            super.add("<option>");
        }
        super.add(o);
        return this;
    }

    public Select add(Object o, boolean selected, String value) {
        if (selected) {
            super.add("<option selected value=\"" + value + "\">");
        } else {
            super.add("<option value=\"" + value + "\">");
        }
        super.add(o);
        return this;
    }

    public Select add(String[] arr, int selected) {
        int i = 0;
        while (i < arr.length) {
            this.add(arr[i], i == selected, Integer.toString(i));
            ++i;
        }
        return this;
    }

    public Select add(String[] arr, String selected) {
        int i = 0;
        while (i < arr.length) {
            this.add(arr[i], arr[i].equals(selected));
            ++i;
        }
        return this;
    }

    public static int bitsetFormResult(String result) {
        int i;
        int from = 0;
        int res = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result:" + result));
        }
        String sres = null;
        while ((i = result.indexOf(32, from)) != -1) {
            sres = result.substring(from, i);
            res |= Integer.parseInt(sres);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Match:" + sres + "+ res=" + res));
            }
            from = i + 1;
        }
        sres = result.substring(from);
        res |= Integer.parseInt(sres);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Match:" + sres + ", res=" + res));
        }
        return res;
    }
}

