/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import org.apache.commons.logging.Log;

public class ContextLoader
extends URLClassLoader {
    private static Log log = LogFactory.getLog(ContextLoader.class);
    private boolean _java2compliant = false;
    private ClassLoader _parent;
    private PermissionCollection _permissions;
    private String _urlClassPath;
    private HttpContext _context;

    public ContextLoader(HttpContext context, String classPath, ClassLoader parent, PermissionCollection permisions) throws MalformedURLException, IOException {
        super(new URL[0], parent);
        this._context = context;
        this._permissions = permisions;
        this._parent = parent;
        if (this._parent == null) {
            this._parent = ContextLoader.getSystemClassLoader();
        }
        if (classPath == null) {
            this._urlClassPath = "";
        } else {
            StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
            while (tokenizer.hasMoreTokens()) {
                URL url;
                File file;
                Resource resource = Resource.newResource(tokenizer.nextToken());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Path resource=" + resource));
                }
                if ((file = resource.getFile()) != null) {
                    url = resource.getURL();
                    this.addURL(url);
                    this._urlClassPath = this._urlClassPath == null ? url.toString() : String.valueOf(this._urlClassPath) + "," + url.toString();
                    continue;
                }
                if (!resource.isDirectory() && file == null) {
                    InputStream in = resource.getInputStream();
                    File lib = new File(context.getTempDirectory(), "lib");
                    if (!lib.exists()) {
                        lib.mkdir();
                        lib.deleteOnExit();
                    }
                    File jar = File.createTempFile("Jetty-", ".jar", lib);
                    jar.deleteOnExit();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Extract " + resource + " to " + jar));
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(jar);
                        IO.copy(in, out);
                    }
                    catch (Throwable throwable) {
                        IO.close(out);
                        throw throwable;
                    }
                    IO.close(out);
                    URL url2 = jar.toURL();
                    this.addURL(url2);
                    this._urlClassPath = this._urlClassPath == null ? url2.toString() : String.valueOf(this._urlClassPath) + "," + url2.toString();
                    continue;
                }
                url = resource.getURL();
                this.addURL(url);
                String string = this._urlClassPath = this._urlClassPath == null ? url.toString() : String.valueOf(this._urlClassPath) + "," + url.toString();
            }
        }
        if (log.isDebugEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ClassPath=" + this._urlClassPath));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Permissions=" + this._permissions));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL=" + Arrays.asList(this.getURLs())));
            }
        }
    }

    public void setJava2Compliant(boolean compliant) {
        this._java2compliant = compliant;
    }

    public boolean isJava2Compliant() {
        return this._java2compliant;
    }

    public String toString() {
        return "ContextLoader@" + this.hashCode() + "(" + this._urlClassPath + ")\n  --parent--> " + this._parent.toString();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc;
        PermissionCollection permissionCollection = pc = this._permissions == null ? super.getPermissions(cs) : this._permissions;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loader.getPermissions(" + cs + ")=" + pc));
        }
        return pc;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c == null && (this._java2compliant || this.isSystemPath(name)) && !this.isServerPath(name) && this._parent != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try loadClass " + name + " from " + this._parent));
            }
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("p0 loaded " + c));
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try findClass " + name + " from " + this._urlClassPath));
            }
            try {
                c = this.findClass(name);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("cx loaded " + c));
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && !tried_parent && !this.isServerPath(name) && this._parent != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try loadClass " + name + " from " + this._parent));
            }
            c = this._parent.loadClass(name);
            if (log.isTraceEnabled()) {
                log.trace((Object)("p1 loaded " + c));
            }
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._parent != null && (this._java2compliant || this.isSystemPath(name))) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try getResource " + name + " from " + this._parent));
            }
            tried_parent = true;
            url = this._parent.getResource(name);
        }
        if (url == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try findResource " + name + " from " + this._urlClassPath));
            }
            if ((url = this.findResource(name)) == null && name.startsWith("/")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("HACK leading / off " + name));
                }
                url = this.findResource(name.substring(1));
            }
        }
        if (this._parent != null && url == null && !tried_parent) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try getResource " + name + " from " + this._parent));
            }
            url = this._parent.getResource(name);
        }
        if (url != null && log.isTraceEnabled()) {
            log.trace((Object)("found " + url));
        }
        return url;
    }

    public boolean isServerPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] server_classes = this._context.getServerClasses();
        if (server_classes != null) {
            int i = 0;
            while (i < server_classes.length) {
                boolean result = true;
                String c = server_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (c.endsWith(".") ? name.startsWith(c) : name.equals(c)) {
                    return result;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isSystemPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] system_classes = this._context.getSystemClasses();
        if (system_classes != null) {
            int i = 0;
            while (i < system_classes.length) {
                boolean result = true;
                String c = system_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (c.endsWith(".") ? name.startsWith(c) : name.equals(c)) {
                    return result;
                }
                ++i;
            }
        }
        return false;
    }

    public void destroy() {
        this._parent = null;
        this._permissions = null;
        this._urlClassPath = null;
    }

    String[] getServerClasses() {
        return this._context.getServerClasses();
    }

    void setServerClasses(String[] serverClasses) {
        this._context.setServerClasses(serverClasses);
    }

    String[] getSystemClasses() {
        return this._context.getSystemClasses();
    }

    void setSystemClasses(String[] systemClasses) {
        this._context.setSystemClasses(systemClasses);
    }
}

