/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http.jmx;

import java.util.HashMap;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.RequestLog;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.LifeCycleEvent;
import net.lightbody.bmp.proxy.jetty.util.LifeCycleListener;
import net.lightbody.bmp.proxy.jetty.util.jmx.LifeCycleMBean;
import net.lightbody.bmp.proxy.jetty.util.jmx.ModelMBeanImpl;
import org.apache.commons.logging.Log;

public class HttpContextMBean
extends LifeCycleMBean {
    private static Log log = LogFactory.getLog(HttpContextMBean.class);
    private HttpContext _httpContext;
    private HashMap _rlMap = new HashMap(3);
    private HashMap _handlerMap = new HashMap();

    @Override
    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("virtualHosts");
        this.defineAttribute("hosts");
        this.defineAttribute("contextPath");
        this.defineAttribute("handlers", false, true);
        this.defineAttribute("requestLog", false, true);
        this.defineAttribute("classPath");
        this.defineAttribute("realm");
        this.defineAttribute("realmName");
        this.defineAttribute("redirectNullPath");
        this.defineAttribute("resourceBase");
        this.defineAttribute("maxCachedFileSize");
        this.defineAttribute("maxCacheSize");
        this.defineOperation("flushCache", 1);
        this.defineOperation("getResource", new String[]{"java.lang.String"}, 1);
        this.defineAttribute("welcomeFiles");
        this.defineOperation("addWelcomeFile", new String[]{"java.lang.String"}, 0);
        this.defineOperation("removeWelcomeFile", new String[]{"java.lang.String"}, 0);
        this.defineAttribute("mimeMap");
        this.defineOperation("setMimeMapping", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineAttribute("statsOn");
        this.defineAttribute("statsOnMs");
        this.defineOperation("statsReset", 1);
        this.defineAttribute("requests");
        this.defineAttribute("requestsActive");
        this.defineAttribute("requestsActiveMax");
        this.defineAttribute("responses1xx");
        this.defineAttribute("responses2xx");
        this.defineAttribute("responses3xx");
        this.defineAttribute("responses4xx");
        this.defineAttribute("responses5xx");
        this.defineOperation("stop", new String[]{"java.lang.Boolean.TYPE"}, 1);
        this.defineOperation("destroy", 1);
        this.defineOperation("setInitParameter", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("getInitParameter", new String[]{"java.lang.String"}, 0);
        this.defineOperation("getInitParameterNames", ModelMBeanImpl.NO_PARAMS, 0);
        this.defineOperation("setAttribute", new String[]{"java.lang.String", "java.lang.Object"}, 1);
        this.defineOperation("getAttribute", new String[]{"java.lang.String"}, 0);
        this.defineOperation("getAttributeNames", ModelMBeanImpl.NO_PARAMS, 0);
        this.defineOperation("removeAttribute", new String[]{"java.lang.String"}, 1);
        this.defineOperation("addHandler", new String[]{"HttpHandler"}, 1);
        this.defineOperation("addHandler", new String[]{"int", "HttpHandler"}, 1);
        this.defineOperation("removeHandler", new String[]{"int"}, 1);
        this._httpContext = (HttpContext)this.getManagedResource();
        this._httpContext.addEventListener(new LifeCycleListener(){

            @Override
            public void lifeCycleStarting(LifeCycleEvent event) {
            }

            @Override
            public void lifeCycleStarted(LifeCycleEvent event) {
                HttpContextMBean.this.getHandlers();
            }

            @Override
            public void lifeCycleFailure(LifeCycleEvent event) {
            }

            @Override
            public void lifeCycleStopping(LifeCycleEvent event) {
            }

            @Override
            public void lifeCycleStopped(LifeCycleEvent event) {
                HttpContextMBean.this.destroyHandlers();
            }
        });
    }

    @Override
    protected ObjectName newObjectName(MBeanServer server) {
        ObjectName oName = super.newObjectName(server);
        String context = this._httpContext.getContextPath();
        if (context.length() == 0) {
            context = "/";
        }
        try {
            oName = new ObjectName(oName + ",context=" + context);
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        return oName;
    }

    @Override
    public void postRegister(Boolean ok) {
        super.postRegister(ok);
        if (ok.booleanValue()) {
            this.getHandlers();
        }
    }

    @Override
    public void postDeregister() {
        this._httpContext = null;
        this.destroyComponentMBeans(this._handlerMap);
        super.postDeregister();
    }

    public ObjectName[] getHandlers() {
        return this.getComponentMBeans(this._httpContext.getHandlers(), this._handlerMap);
    }

    public void destroyHandlers() {
        this.destroyComponentMBeans(this._handlerMap);
    }

    public ObjectName getRequestLog() {
        RequestLog o = this._httpContext.getRequestLog();
        if (o == null) {
            return null;
        }
        ObjectName[] on = this.getComponentMBeans(new Object[]{o}, this._rlMap);
        if (on.length > 0) {
            return on[0];
        }
        return null;
    }
}

