/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.LineInput;
import net.lightbody.bmp.proxy.jetty.util.MultiMap;
import net.lightbody.bmp.proxy.jetty.util.StringUtil;
import org.apache.commons.logging.Log;

public class MultiPartRequest {
    private static Log log = LogFactory.getLog(MultiPartRequest.class);
    HttpServletRequest _request;
    LineInput _in;
    String _boundary;
    String _encoding;
    byte[] _byteBoundary;
    MultiMap _partMap = new MultiMap(10);
    int _char = -2;
    boolean _lastPart = false;

    public MultiPartRequest(HttpServletRequest request) throws IOException {
        this._request = request;
        String content_type = request.getHeader("Content-Type");
        if (!content_type.startsWith("multipart/form-data")) {
            throw new IOException("Not multipart/form-data request");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Multipart content type = " + content_type));
        }
        this._encoding = request.getCharacterEncoding();
        this._in = this._encoding != null ? new LineInput((InputStream)request.getInputStream(), 2048, this._encoding) : new LineInput((InputStream)request.getInputStream());
        this._boundary = "--" + this.value(content_type.substring(content_type.indexOf("boundary=")));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Boundary=" + this._boundary));
        }
        this._byteBoundary = (String.valueOf(this._boundary) + "--").getBytes(StringUtil.__ISO_8859_1);
        this.loadAllParts();
    }

    public String[] getPartNames() {
        Set s = this._partMap.keySet();
        return s.toArray(new String[s.size()]);
    }

    public boolean contains(String name) {
        Part part = (Part)this._partMap.get(name);
        return part != null;
    }

    public String getString(String name) {
        List part = this._partMap.getValues(name);
        if (part == null) {
            return null;
        }
        if (this._encoding != null) {
            try {
                return new String(((Part)part.get((int)0))._data, this._encoding);
            }
            catch (UnsupportedEncodingException uee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid character set: " + uee));
                }
                return null;
            }
        }
        return new String(((Part)part.get((int)0))._data);
    }

    public String[] getStrings(String name) {
        List parts = this._partMap.getValues(name);
        if (parts == null) {
            return null;
        }
        String[] strings = new String[parts.size()];
        if (this._encoding == null) {
            int i = 0;
            while (i < strings.length) {
                strings[i] = new String(((Part)parts.get((int)i))._data);
                ++i;
            }
        } else {
            try {
                int i = 0;
                while (i < strings.length) {
                    strings[i] = new String(((Part)parts.get((int)i))._data, this._encoding);
                    ++i;
                }
            }
            catch (UnsupportedEncodingException uee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid character set: " + uee));
                }
                return null;
            }
        }
        return strings;
    }

    public InputStream getInputStream(String name) {
        List part = this._partMap.getValues(name);
        if (part == null) {
            return null;
        }
        return new ByteArrayInputStream(((Part)part.get((int)0))._data);
    }

    public InputStream[] getInputStreams(String name) {
        List parts = this._partMap.getValues(name);
        if (parts == null) {
            return null;
        }
        InputStream[] streams = new InputStream[parts.size()];
        int i = 0;
        while (i < streams.length) {
            streams[i] = new ByteArrayInputStream(((Part)parts.get((int)i))._data);
            ++i;
        }
        return streams;
    }

    public Hashtable getParams(String name) {
        List part = this._partMap.getValues(name);
        if (part == null) {
            return null;
        }
        return ((Part)part.get((int)0))._headers;
    }

    public Hashtable[] getMultipleParams(String name) {
        List parts = this._partMap.getValues(name);
        if (parts == null) {
            return null;
        }
        Hashtable[] params = new Hashtable[parts.size()];
        int i = 0;
        while (i < params.length) {
            params[i] = ((Part)parts.get((int)i))._headers;
            ++i;
        }
        return params;
    }

    public String getFilename(String name) {
        List part = this._partMap.getValues(name);
        if (part == null) {
            return null;
        }
        return ((Part)part.get((int)0))._filename;
    }

    public String[] getFilenames(String name) {
        List parts = this._partMap.getValues(name);
        if (parts == null) {
            return null;
        }
        String[] filenames = new String[parts.size()];
        int i = 0;
        while (i < filenames.length) {
            filenames[i] = ((Part)parts.get((int)i))._filename;
            ++i;
        }
        return filenames;
    }

    /*
     * Unable to fully structure code
     */
    private void loadAllParts() throws IOException {
        line = this._in.readLine();
        if (line.equals(this._boundary)) ** GOTO lbl50
        MultiPartRequest.log.warn((Object)line);
        throw new IOException("Missing initial multi part boundary");
lbl-1000:
        // 1 sources

        {
            part = new Part();
            content_disposition = null;
            while ((line = this._in.readLine()) != null) {
                if (line.length() == 0) break;
                if (MultiPartRequest.log.isDebugEnabled()) {
                    MultiPartRequest.log.debug((Object)("LINE=" + line));
                }
                if ((c = line.indexOf(58, 0)) <= 0) continue;
                key = line.substring(0, c).trim().toLowerCase();
                value = line.substring(c + 1, line.length()).trim();
                ev = (String)part._headers.get(key);
                part._headers.put(key, ev != null ? String.valueOf(ev) + ';' + value : value);
                if (MultiPartRequest.log.isDebugEnabled()) {
                    MultiPartRequest.log.debug((Object)(String.valueOf(key) + ": " + value));
                }
                if (!key.equals("content-disposition")) continue;
                content_disposition = value;
            }
            form_data = false;
            if (content_disposition == null) {
                throw new IOException("Missing content-disposition");
            }
            tok = new StringTokenizer(content_disposition, ";");
            while (tok.hasMoreTokens()) {
                t = tok.nextToken().trim();
                tl = t.toLowerCase();
                if (t.startsWith("form-data")) {
                    form_data = true;
                    continue;
                }
                if (tl.startsWith("name=")) {
                    part._name = this.value(t);
                    continue;
                }
                if (!tl.startsWith("filename=")) continue;
                part._filename = this.value(t);
            }
            if (!form_data) {
                MultiPartRequest.log.warn((Object)"Non form-data part in multipart/form-data");
                continue;
            }
            if (part._name == null || part._name.length() == 0) {
                MultiPartRequest.log.warn((Object)"Part with no name in multipart/form-data");
                continue;
            }
            if (MultiPartRequest.log.isDebugEnabled()) {
                MultiPartRequest.log.debug((Object)("name=" + part._name));
            }
            if (MultiPartRequest.log.isDebugEnabled()) {
                MultiPartRequest.log.debug((Object)("filename=" + part._filename));
            }
            this._partMap.add(part._name, part);
            part._data = this.readBytes();
lbl50:
            // 4 sources

            ** while (!this._lastPart)
        }
lbl51:
        // 1 sources

    }

    private byte[] readBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean cr = false;
        boolean lf = false;
        while (true) {
            int c;
            int b = 0;
            while ((c = this._char != -2 ? this._char : this._in.read()) != -1) {
                this._char = -2;
                if (c == 13 || c == 10) {
                    if (c != 13) break;
                    this._char = this._in.read();
                    break;
                }
                if (b >= 0 && b < this._byteBoundary.length && c == this._byteBoundary[b]) {
                    ++b;
                    continue;
                }
                if (cr) {
                    baos.write(13);
                }
                if (lf) {
                    baos.write(10);
                }
                lf = false;
                cr = false;
                if (b > 0) {
                    baos.write(this._byteBoundary, 0, b);
                }
                b = -1;
                baos.write(c);
            }
            if (b > 0 && b < this._byteBoundary.length - 2 || b == this._byteBoundary.length - 1) {
                if (cr) {
                    baos.write(13);
                }
                if (lf) {
                    baos.write(10);
                }
                lf = false;
                cr = false;
                baos.write(this._byteBoundary, 0, b);
                b = -1;
            }
            if (b > 0 || c == -1) {
                if (b == this._byteBoundary.length) {
                    this._lastPart = true;
                }
                if (this._char != 10) break;
                this._char = -2;
                break;
            }
            if (cr) {
                baos.write(13);
            }
            if (lf) {
                baos.write(10);
            }
            cr = c == 13;
            boolean bl = lf = c == 10 || this._char == 10;
            if (this._char != 10) continue;
            this._char = -2;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)baos.toString());
        }
        return baos.toByteArray();
    }

    private String value(String nameEqualsValue) {
        String value = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i = value.indexOf(59);
        if (i > 0) {
            value = value.substring(0, i);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf(34, 1));
        } else {
            i = value.indexOf(32);
            if (i > 0) {
                value = value.substring(0, i);
            }
        }
        return value;
    }

    private class Part {
        String _name = null;
        String _filename = null;
        Hashtable _headers = new Hashtable(10);
        byte[] _data = null;

        private Part() {
        }
    }
}

