/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import com.google.common.net.HostAndPort;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ChannelFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.SSLProtocolException;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.ChainedProxy;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.FullFlowContext;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.TransportProtocol;
import org.littleshoot.proxy.UnknownTransportProtocolException;
import org.littleshoot.proxy.impl.ClientToProxyConnection;
import org.littleshoot.proxy.impl.ConnectionFlow;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyUtils;

@ChannelHandler.Sharable
public class ProxyToServerConnection
extends ProxyConnection<HttpResponse> {
    private final ClientToProxyConnection clientConnection;
    private final ProxyToServerConnection serverConnection = this;
    private volatile TransportProtocol transportProtocol;
    private volatile InetSocketAddress remoteAddress;
    private volatile InetSocketAddress localAddress;
    private final String serverHostAndPort;
    private volatile ChainedProxy chainedProxy;
    private final Queue<ChainedProxy> availableChainedProxies;
    private volatile HttpFilters currentFilters;
    private volatile ConnectionFlow connectionFlow;
    private volatile boolean disableSni = false;
    private final Object connectLock = new Object();
    private volatile HttpRequest initialRequest;
    private final Queue<HttpRequest> issuedRequests = new LinkedList<HttpRequest>();
    private volatile HttpRequest currentHttpRequest;
    private volatile HttpResponse currentHttpResponse;
    private volatile GlobalTrafficShapingHandler trafficHandler;
    private static final int MINIMUM_RECV_BUFFER_SIZE_BYTES = 64;
    private ConnectionFlowStep ConnectChannel = new ConnectionFlowStep(this, ConnectionState.CONNECTING){

        @Override
        boolean shouldExecuteOnEventLoop() {
            return false;
        }

        protected Future<?> execute() {
            Bootstrap cb = (Bootstrap)new Bootstrap().group(ProxyToServerConnection.this.proxyServer.getProxyToServerWorkerFor(ProxyToServerConnection.this.transportProtocol));
            switch (ProxyToServerConnection.this.transportProtocol) {
                case TCP: {
                    ProxyToServerConnection.this.LOG.debug("Connecting to server with TCP", new Object[0]);
                    cb.channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                        public Channel newChannel() {
                            return new NioSocketChannel();
                        }
                    });
                    break;
                }
                case UDT: {
                    ProxyToServerConnection.this.LOG.debug("Connecting to server with UDT", new Object[0]);
                    ((Bootstrap)cb.channelFactory(NioUdtProvider.BYTE_CONNECTOR)).option(ChannelOption.SO_REUSEADDR, (Object)true);
                    break;
                }
                default: {
                    throw new UnknownTransportProtocolException(ProxyToServerConnection.this.transportProtocol);
                }
            }
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ProxyToServerConnection.this.initChannelPipeline(ch.pipeline(), ProxyToServerConnection.this.initialRequest);
                }
            });
            cb.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)ProxyToServerConnection.this.proxyServer.getConnectTimeout());
            if (ProxyToServerConnection.this.localAddress != null) {
                return cb.connect((SocketAddress)ProxyToServerConnection.this.remoteAddress, (SocketAddress)ProxyToServerConnection.this.localAddress);
            }
            return cb.connect((SocketAddress)ProxyToServerConnection.this.remoteAddress);
        }
    };
    private ConnectionFlowStep HTTPCONNECTWithChainedProxy = new ConnectionFlowStep(this, ConnectionState.AWAITING_CONNECT_OK){

        protected Future<?> execute() {
            boolean isMitmEnabled;
            ProxyToServerConnection.this.LOG.debug("Handling CONNECT request through Chained Proxy", new Object[0]);
            ProxyToServerConnection.this.chainedProxy.filterRequest((HttpObject)ProxyToServerConnection.this.initialRequest);
            MitmManager mitmManager = ProxyToServerConnection.this.proxyServer.getMitmManager();
            boolean bl = isMitmEnabled = mitmManager != null;
            if (isMitmEnabled) {
                ChannelFuture future = ProxyToServerConnection.this.writeToChannel(ProxyToServerConnection.this.initialRequest);
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture arg0) throws Exception {
                        if (arg0.isSuccess()) {
                            ProxyToServerConnection.this.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT);
                        }
                    }
                });
                return future;
            }
            return ProxyToServerConnection.this.writeToChannel(ProxyToServerConnection.this.initialRequest);
        }

        @Override
        void onSuccess(ConnectionFlow flow) {
        }

        @Override
        void read(ConnectionFlow flow, Object msg) {
            HttpResponse httpResponse;
            int statusCode;
            boolean connectOk = false;
            if (msg instanceof HttpResponse && (statusCode = (httpResponse = (HttpResponse)msg).getStatus().code()) >= 200 && statusCode <= 299) {
                connectOk = true;
            }
            if (connectOk) {
                flow.advance();
            } else {
                flow.fail();
            }
        }
    };
    private ConnectionFlowStep MitmEncryptClientChannel = new ConnectionFlowStep(this, ConnectionState.HANDSHAKING){

        @Override
        boolean shouldExecuteOnEventLoop() {
            return false;
        }

        @Override
        boolean shouldSuppressInitialRequest() {
            return true;
        }

        protected Future<?> execute() {
            return ProxyToServerConnection.this.clientConnection.encrypt(ProxyToServerConnection.this.proxyServer.getMitmManager().clientSslEngineFor(ProxyToServerConnection.this.initialRequest, ProxyToServerConnection.this.sslEngine.getSession()), false).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                public void operationComplete(Future<? super Channel> future) throws Exception {
                    if (future.isSuccess()) {
                        ProxyToServerConnection.this.clientConnection.setMitming(true);
                    }
                }
            });
        }
    };
    private final ProxyConnection.BytesReadMonitor bytesReadMonitor = new ProxyConnection.BytesReadMonitor(){

        @Override
        protected void bytesRead(int numberOfBytes) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesReceivedFromServer(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.ResponseReadMonitor responseReadMonitor = new ProxyConnection.ResponseReadMonitor(){

        @Override
        protected void responseRead(HttpResponse httpResponse) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.responseReceivedFromServer(flowContext, httpResponse);
            }
        }
    };
    private ProxyConnection.BytesWrittenMonitor bytesWrittenMonitor = new ProxyConnection.BytesWrittenMonitor(){

        @Override
        protected void bytesWritten(int numberOfBytes) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesSentToServer(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.RequestWrittenMonitor requestWrittenMonitor = new ProxyConnection.RequestWrittenMonitor(){

        @Override
        protected void requestWriting(HttpRequest httpRequest) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            try {
                for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                    tracker.requestSentToServer(flowContext, httpRequest);
                }
            }
            catch (Throwable t) {
                ProxyToServerConnection.this.LOG.warn("Error while invoking ActivityTracker on request", t);
            }
            ProxyToServerConnection.this.currentFilters.proxyToServerRequestSending();
        }

        @Override
        protected void requestWritten(HttpRequest httpRequest) {
        }

        @Override
        protected void contentWritten(HttpContent httpContent) {
            if (httpContent instanceof LastHttpContent) {
                ProxyToServerConnection.this.currentFilters.proxyToServerRequestSent();
            }
        }
    };

    static ProxyToServerConnection create(DefaultHttpProxyServer proxyServer, ClientToProxyConnection clientConnection, String serverHostAndPort, HttpFilters initialFilters, HttpRequest initialHttpRequest, GlobalTrafficShapingHandler globalTrafficShapingHandler) throws UnknownHostException {
        ConcurrentLinkedQueue<ChainedProxy> chainedProxies = new ConcurrentLinkedQueue<ChainedProxy>();
        ChainedProxyManager chainedProxyManager = proxyServer.getChainProxyManager();
        if (chainedProxyManager != null) {
            chainedProxyManager.lookupChainedProxies(initialHttpRequest, chainedProxies);
            if (chainedProxies.size() == 0) {
                return null;
            }
        }
        return new ProxyToServerConnection(proxyServer, clientConnection, serverHostAndPort, (ChainedProxy)chainedProxies.poll(), chainedProxies, initialFilters, globalTrafficShapingHandler);
    }

    private ProxyToServerConnection(DefaultHttpProxyServer proxyServer, ClientToProxyConnection clientConnection, String serverHostAndPort, ChainedProxy chainedProxy, Queue<ChainedProxy> availableChainedProxies, HttpFilters initialFilters, GlobalTrafficShapingHandler globalTrafficShapingHandler) throws UnknownHostException {
        super(ConnectionState.DISCONNECTED, proxyServer, true);
        this.clientConnection = clientConnection;
        this.serverHostAndPort = serverHostAndPort;
        this.chainedProxy = chainedProxy;
        this.availableChainedProxies = availableChainedProxies;
        this.trafficHandler = globalTrafficShapingHandler;
        this.currentFilters = initialFilters;
        this.currentFilters.proxyToServerConnectionQueued();
        this.setupConnectionParameters();
    }

    @Override
    protected void read(Object msg) {
        if (this.isConnecting()) {
            this.LOG.debug("In the middle of connecting, forwarding message to connection flow: {}", msg);
            this.connectionFlow.read(msg);
        } else {
            super.read(msg);
        }
    }

    @Override
    protected ConnectionState readHTTPInitial(HttpResponse httpResponse) {
        this.LOG.debug("Received raw response: {}", httpResponse);
        this.currentFilters.serverToProxyResponseReceiving();
        this.rememberCurrentResponse(httpResponse);
        this.respondWith((HttpObject)httpResponse);
        if (ProxyUtils.isChunked((HttpObject)httpResponse)) {
            return ConnectionState.AWAITING_CHUNK;
        }
        this.currentFilters.serverToProxyResponseReceived();
        return ConnectionState.AWAITING_INITIAL;
    }

    @Override
    protected void readHTTPChunk(HttpContent chunk) {
        this.respondWith((HttpObject)chunk);
    }

    @Override
    protected void readRaw(ByteBuf buf) {
        this.clientConnection.write(buf);
    }

    void write(Object msg, HttpFilters filters) {
        this.currentFilters = filters;
        this.write(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void write(Object msg) {
        this.LOG.debug("Requested write of {}", msg);
        if (msg instanceof ReferenceCounted) {
            this.LOG.debug("Retaining reference counted message", new Object[0]);
            ((ReferenceCounted)msg).retain();
        }
        if (this.is(ConnectionState.DISCONNECTED) && msg instanceof HttpRequest) {
            this.LOG.debug("Currently disconnected, connect and then write the message", new Object[0]);
            this.connectAndWrite((HttpRequest)msg);
        } else {
            if (this.isConnecting()) {
                Object object = this.connectLock;
                synchronized (object) {
                    if (this.isConnecting()) {
                        this.LOG.debug("Attempted to write while still in the process of connecting, waiting for connection.", new Object[0]);
                        this.clientConnection.stopReading();
                        try {
                            this.connectLock.wait(30000L);
                        }
                        catch (InterruptedException ie) {
                            this.LOG.warn("Interrupted while waiting for connect monitor", new Object[0]);
                        }
                    }
                }
            }
            if (this.isConnecting() || this.getCurrentState().isDisconnectingOrDisconnected()) {
                this.LOG.debug("Connection failed or timed out while waiting to write message to server. Message will be discarded: {}", msg);
                return;
            }
            this.LOG.debug("Using existing connection to: {}", this.remoteAddress);
            this.doWrite(msg);
        }
    }

    @Override
    protected void writeHttp(HttpObject httpObject) {
        if (this.chainedProxy != null) {
            this.chainedProxy.filterRequest(httpObject);
        }
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            this.issuedRequests.add(httpRequest);
        }
        super.writeHttp(httpObject);
    }

    @Override
    protected void become(ConnectionState newState) {
        if (this.getCurrentState() == ConnectionState.DISCONNECTED && newState == ConnectionState.CONNECTING) {
            this.currentFilters.proxyToServerConnectionStarted();
        } else if (this.getCurrentState() == ConnectionState.CONNECTING) {
            if (newState == ConnectionState.HANDSHAKING) {
                this.currentFilters.proxyToServerConnectionSSLHandshakeStarted();
            } else if (newState == ConnectionState.AWAITING_INITIAL) {
                this.currentFilters.proxyToServerConnectionSucceeded(this.ctx);
            } else if (newState == ConnectionState.DISCONNECTED) {
                this.currentFilters.proxyToServerConnectionFailed();
            }
        } else if (this.getCurrentState() == ConnectionState.HANDSHAKING) {
            if (newState == ConnectionState.AWAITING_INITIAL) {
                this.currentFilters.proxyToServerConnectionSucceeded(this.ctx);
            } else if (newState == ConnectionState.DISCONNECTED) {
                this.currentFilters.proxyToServerConnectionFailed();
            }
        } else if (this.getCurrentState() == ConnectionState.AWAITING_CHUNK && newState != ConnectionState.AWAITING_CHUNK) {
            this.currentFilters.serverToProxyResponseReceived();
        }
        super.become(newState);
    }

    @Override
    protected void becameSaturated() {
        super.becameSaturated();
        this.clientConnection.serverBecameSaturated(this);
    }

    @Override
    protected void becameWritable() {
        super.becameWritable();
        this.clientConnection.serverBecameWriteable(this);
    }

    @Override
    protected void timedOut() {
        super.timedOut();
        this.clientConnection.timedOut();
    }

    @Override
    protected void disconnected() {
        super.disconnected();
        if (this.chainedProxy != null) {
            try {
                this.chainedProxy.disconnected();
            }
            catch (Exception e) {
                this.LOG.error("Unable to record connectionFailed", e);
            }
        }
        this.clientConnection.serverDisconnected(this);
    }

    @Override
    protected void exceptionCaught(Throwable cause) {
        try {
            if (cause instanceof IOException) {
                this.LOG.info("An IOException occurred on ProxyToServerConnection: " + cause.getMessage(), new Object[0]);
                this.LOG.debug("An IOException occurred on ProxyToServerConnection", cause);
            } else if (cause instanceof RejectedExecutionException) {
                this.LOG.info("An executor rejected a read or write operation on the ProxyToServerConnection (this is normal if the proxy is shutting down). Message: " + cause.getMessage(), new Object[0]);
                this.LOG.debug("A RejectedExecutionException occurred on ProxyToServerConnection", cause);
            } else {
                this.LOG.error("Caught an exception on ProxyToServerConnection", cause);
            }
        }
        finally {
            if (!this.is(ConnectionState.DISCONNECTED)) {
                this.LOG.info("Disconnecting open connection to server", new Object[0]);
                this.disconnect();
            }
        }
    }

    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getServerHostAndPort() {
        return this.serverHostAndPort;
    }

    public boolean hasUpstreamChainedProxy() {
        return this.getChainedProxyAddress() != null;
    }

    public InetSocketAddress getChainedProxyAddress() {
        return this.chainedProxy == null ? null : this.chainedProxy.getChainedProxyAddress();
    }

    public ChainedProxy getChainedProxy() {
        return this.chainedProxy;
    }

    public HttpRequest getInitialRequest() {
        return this.initialRequest;
    }

    @Override
    protected HttpFilters getHttpFiltersFromProxyServer(HttpRequest httpRequest) {
        return this.currentFilters;
    }

    private void identifyCurrentRequest() {
        this.LOG.debug("Remembering the current request.", new Object[0]);
        if (!this.issuedRequests.isEmpty()) {
            this.currentHttpRequest = this.issuedRequests.remove();
            if (this.currentHttpRequest == null) {
                this.LOG.warn("Got null HTTP request object.", new Object[0]);
            }
        } else {
            this.LOG.debug("Request queue is empty!", new Object[0]);
        }
    }

    private void rememberCurrentResponse(HttpResponse response) {
        this.LOG.debug("Remembering the current response.", new Object[0]);
        this.currentHttpResponse = ProxyUtils.copyMutableResponseFields(response);
    }

    private void respondWith(HttpObject httpObject) {
        this.clientConnection.respond(this, this.currentFilters, this.currentHttpRequest, this.currentHttpResponse, httpObject);
    }

    private void connectAndWrite(HttpRequest initialRequest) {
        this.LOG.debug("Starting new connection to: {}", this.remoteAddress);
        this.initialRequest = initialRequest;
        this.initializeConnectionFlow();
        this.connectionFlow.start();
    }

    private void initializeConnectionFlow() {
        this.connectionFlow = new ConnectionFlow(this.clientConnection, this, this.connectLock).then(this.ConnectChannel);
        if (this.chainedProxy != null && this.chainedProxy.requiresEncryption()) {
            this.connectionFlow.then(this.serverConnection.EncryptChannel(this.chainedProxy.newSslEngine()));
        }
        if (ProxyUtils.isCONNECT((HttpObject)this.initialRequest)) {
            MitmManager mitmManager;
            boolean isMitmEnabled;
            if (this.hasUpstreamChainedProxy()) {
                this.connectionFlow.then(this.serverConnection.HTTPCONNECTWithChainedProxy);
            }
            boolean bl = isMitmEnabled = (mitmManager = this.proxyServer.getMitmManager()) != null;
            if (isMitmEnabled) {
                HostAndPort parsedHostAndPort = HostAndPort.fromString((String)this.serverHostAndPort);
                if (this.disableSni) {
                    this.connectionFlow.then(this.serverConnection.EncryptChannel(this.proxyServer.getMitmManager().serverSslEngine()));
                } else {
                    this.connectionFlow.then(this.serverConnection.EncryptChannel(this.proxyServer.getMitmManager().serverSslEngine(parsedHostAndPort.getHostText(), parsedHostAndPort.getPort())));
                }
                this.connectionFlow.then(this.clientConnection.RespondCONNECTSuccessful).then(this.serverConnection.MitmEncryptClientChannel);
            } else {
                this.connectionFlow.then(this.serverConnection.StartTunneling).then(this.clientConnection.RespondCONNECTSuccessful).then(this.clientConnection.StartTunneling);
            }
        }
    }

    protected boolean connectionFailed(Throwable cause) throws UnknownHostException {
        if (!this.disableSni && cause instanceof SSLProtocolException && cause.getMessage() != null && cause.getMessage().contains("unrecognized_name")) {
            this.LOG.debug("Failed to connect to server due to an unrecognized_name SSL warning. Retrying connection without SNI.", new Object[0]);
            this.disableSni = true;
            this.resetConnectionForRetry();
            this.connectAndWrite(this.initialRequest);
            return true;
        }
        this.disableSni = false;
        if (this.chainedProxy != null) {
            this.LOG.info("Connection to upstream server via chained proxy failed", cause);
            this.chainedProxy.connectionFailed(cause);
        } else {
            this.LOG.info("Connection to upstream server failed", cause);
        }
        this.chainedProxy = this.availableChainedProxies.poll();
        if (this.chainedProxy != null) {
            this.LOG.info("Retrying connecting using the next available chained proxy", new Object[0]);
            this.resetConnectionForRetry();
            this.connectAndWrite(this.initialRequest);
            return true;
        }
        return false;
    }

    private void resetConnectionForRetry() throws UnknownHostException {
        this.ctx.pipeline().remove((ChannelHandler)this);
        this.ctx.close();
        this.ctx = null;
        this.setupConnectionParameters();
    }

    private void setupConnectionParameters() throws UnknownHostException {
        if (this.chainedProxy != null && this.chainedProxy != ChainedProxyAdapter.FALLBACK_TO_DIRECT_CONNECTION) {
            this.transportProtocol = this.chainedProxy.getTransportProtocol();
            this.remoteAddress = this.chainedProxy.getChainedProxyAddress();
            this.localAddress = this.chainedProxy.getLocalAddress();
        } else {
            this.transportProtocol = TransportProtocol.TCP;
            this.remoteAddress = this.currentFilters.proxyToServerResolutionStarted(this.serverHostAndPort);
            String hostAndPort = null;
            try {
                if (this.remoteAddress == null) {
                    hostAndPort = this.serverHostAndPort;
                    this.remoteAddress = ProxyToServerConnection.addressFor(this.serverHostAndPort, this.proxyServer);
                } else if (this.remoteAddress.isUnresolved()) {
                    hostAndPort = HostAndPort.fromParts((String)this.remoteAddress.getHostName(), (int)this.remoteAddress.getPort()).toString();
                    this.remoteAddress = this.proxyServer.getServerResolver().resolve(this.remoteAddress.getHostName(), this.remoteAddress.getPort());
                }
            }
            catch (UnknownHostException e) {
                this.currentFilters.proxyToServerResolutionFailed(hostAndPort);
                throw e;
            }
            this.currentFilters.proxyToServerResolutionSucceeded(this.serverHostAndPort, this.remoteAddress);
            this.localAddress = this.proxyServer.getLocalAddress();
        }
    }

    private void initChannelPipeline(ChannelPipeline pipeline, HttpRequest httpRequest) {
        if (this.trafficHandler != null) {
            pipeline.addLast("global-traffic-shaping", (ChannelHandler)this.trafficHandler);
        }
        pipeline.addLast("bytesReadMonitor", (ChannelHandler)this.bytesReadMonitor);
        pipeline.addLast("bytesWrittenMonitor", (ChannelHandler)this.bytesWrittenMonitor);
        pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("decoder", (ChannelHandler)new HeadAwareHttpResponseDecoder(8192, 16384, 16384));
        int numberOfBytesToBuffer = this.proxyServer.getFiltersSource().getMaximumResponseBufferSizeInBytes();
        if (numberOfBytesToBuffer > 0) {
            this.aggregateContentForFiltering(pipeline, numberOfBytesToBuffer);
        }
        pipeline.addLast("responseReadMonitor", (ChannelHandler)this.responseReadMonitor);
        pipeline.addLast("requestWrittenMonitor", (ChannelHandler)this.requestWrittenMonitor);
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.proxyServer.getIdleConnectionTimeout()));
        pipeline.addLast("handler", (ChannelHandler)this);
    }

    void connectionSucceeded(boolean shouldForwardInitialRequest) {
        this.become(ConnectionState.AWAITING_INITIAL);
        if (this.chainedProxy != null) {
            try {
                this.chainedProxy.connectionSucceeded();
            }
            catch (Exception e) {
                this.LOG.error("Unable to record connectionSucceeded", e);
            }
        }
        this.clientConnection.serverConnectionSucceeded(this, shouldForwardInitialRequest);
        if (shouldForwardInitialRequest) {
            this.LOG.debug("Writing initial request: {}", this.initialRequest);
            this.write(this.initialRequest);
        } else {
            this.LOG.debug("Dropping initial request: {}", this.initialRequest);
        }
    }

    public static InetSocketAddress addressFor(String hostAndPort, DefaultHttpProxyServer proxyServer) throws UnknownHostException {
        HostAndPort parsedHostAndPort;
        try {
            parsedHostAndPort = HostAndPort.fromString((String)hostAndPort);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownHostException(hostAndPort);
        }
        String host = parsedHostAndPort.getHostText();
        int port = parsedHostAndPort.getPortOrDefault(80);
        return proxyServer.getServerResolver().resolve(host, port);
    }

    private class HeadAwareHttpResponseDecoder
    extends HttpResponseDecoder {
        public HeadAwareHttpResponseDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        }

        protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
            if (httpMessage instanceof HttpResponse) {
                ProxyToServerConnection.this.identifyCurrentRequest();
            }
            if (ProxyToServerConnection.this.currentHttpRequest == null) {
                return true;
            }
            return HttpMethod.HEAD.equals((Object)ProxyToServerConnection.this.currentHttpRequest.getMethod()) ? true : super.isContentAlwaysEmpty(httpMessage);
        }
    }
}

