/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.DefaultHostResolver;
import org.littleshoot.proxy.DnsSecServerResolver;
import org.littleshoot.proxy.HostResolver;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpProxyServerBootstrap;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.TransportProtocol;
import org.littleshoot.proxy.UnknownTransportProtocolError;
import org.littleshoot.proxy.impl.ClientToProxyConnection;
import org.littleshoot.proxy.impl.NetworkUtils;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpProxyServer
implements HttpProxyServer {
    private static final long TRAFFIC_SHAPING_CHECK_INTERVAL_MS = 250L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpProxyServer.class);
    private final ServerGroup serverGroup;
    private final TransportProtocol transportProtocol;
    private final InetSocketAddress requestedAddress;
    private volatile InetSocketAddress localAddress;
    private volatile InetSocketAddress boundAddress;
    private final SslEngineSource sslEngineSource;
    private final boolean authenticateSslClients;
    private final ProxyAuthenticator proxyAuthenticator;
    private final ChainedProxyManager chainProxyManager;
    private final MitmManager mitmManager;
    private final HttpFiltersSource filtersSource;
    private final boolean transparent;
    private final int connectTimeout;
    private volatile int idleConnectionTimeout;
    private final HostResolver serverResolver;
    private volatile GlobalTrafficShapingHandler globalTrafficShapingHandler;
    private final Collection<ActivityTracker> activityTrackers = new ConcurrentLinkedQueue<ActivityTracker>();

    public static HttpProxyServerBootstrap bootstrap() {
        return new DefaultHttpProxyServerBootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpProxyServerBootstrap bootstrapFromFile(String path) {
        File propsFile = new File(path);
        Properties props = new Properties();
        if (propsFile.isFile()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propsFile);
                props.load(is);
            }
            catch (IOException e) {
                try {
                    LOG.warn("Could not load props file?", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return new DefaultHttpProxyServerBootstrap(props);
    }

    private DefaultHttpProxyServer(ServerGroup serverGroup, TransportProtocol transportProtocol, InetSocketAddress requestedAddress, SslEngineSource sslEngineSource, boolean authenticateSslClients, ProxyAuthenticator proxyAuthenticator, ChainedProxyManager chainProxyManager, MitmManager mitmManager, HttpFiltersSource filtersSource, boolean transparent, int idleConnectionTimeout, Collection<ActivityTracker> activityTrackers, int connectTimeout, HostResolver serverResolver, long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond, InetSocketAddress localAddress) {
        this.serverGroup = serverGroup;
        this.transportProtocol = transportProtocol;
        this.requestedAddress = requestedAddress;
        this.sslEngineSource = sslEngineSource;
        this.authenticateSslClients = authenticateSslClients;
        this.proxyAuthenticator = proxyAuthenticator;
        this.chainProxyManager = chainProxyManager;
        this.mitmManager = mitmManager;
        this.filtersSource = filtersSource;
        this.transparent = transparent;
        this.idleConnectionTimeout = idleConnectionTimeout;
        if (activityTrackers != null) {
            this.activityTrackers.addAll(activityTrackers);
        }
        this.connectTimeout = connectTimeout;
        this.serverResolver = serverResolver;
        this.globalTrafficShapingHandler = writeThrottleBytesPerSecond > 0L || readThrottleBytesPerSecond > 0L ? this.createGlobalTrafficShapingHandler(transportProtocol, readThrottleBytesPerSecond, writeThrottleBytesPerSecond) : null;
        this.localAddress = localAddress;
    }

    private GlobalTrafficShapingHandler createGlobalTrafficShapingHandler(TransportProtocol transportProtocol, long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond) {
        EventLoopGroup proxyToServerEventLoop = this.getProxyToServerWorkerFor(transportProtocol);
        return new GlobalTrafficShapingHandler((ScheduledExecutorService)proxyToServerEventLoop, writeThrottleBytesPerSecond, readThrottleBytesPerSecond, 250L, Long.MAX_VALUE);
    }

    boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Override
    public void setIdleConnectionTimeout(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HostResolver getServerResolver() {
        return this.serverResolver;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public InetSocketAddress getListenAddress() {
        return this.boundAddress;
    }

    @Override
    public void setThrottle(long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond) {
        if (this.globalTrafficShapingHandler != null) {
            this.globalTrafficShapingHandler.configure(writeThrottleBytesPerSecond, readThrottleBytesPerSecond);
        } else if (readThrottleBytesPerSecond > 0L || writeThrottleBytesPerSecond > 0L) {
            this.globalTrafficShapingHandler = this.createGlobalTrafficShapingHandler(this.transportProtocol, readThrottleBytesPerSecond, writeThrottleBytesPerSecond);
        }
    }

    public long getReadThrottle() {
        return this.globalTrafficShapingHandler.getReadLimit();
    }

    public long getWriteThrottle() {
        return this.globalTrafficShapingHandler.getWriteLimit();
    }

    @Override
    public HttpProxyServerBootstrap clone() {
        return new DefaultHttpProxyServerBootstrap(this, this.transportProtocol, new InetSocketAddress(this.requestedAddress.getAddress(), this.requestedAddress.getPort() == 0 ? 0 : this.requestedAddress.getPort() + 1), this.sslEngineSource, this.authenticateSslClients, this.proxyAuthenticator, this.chainProxyManager, this.mitmManager, this.filtersSource, this.transparent, this.idleConnectionTimeout, this.activityTrackers, this.connectTimeout, this.serverResolver, this.globalTrafficShapingHandler != null ? this.globalTrafficShapingHandler.getReadLimit() : 0L, this.globalTrafficShapingHandler != null ? this.globalTrafficShapingHandler.getWriteLimit() : 0L, this.localAddress);
    }

    @Override
    public void stop() {
        this.serverGroup.stop(true);
    }

    @Override
    public void abort() {
        this.serverGroup.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpProxyServer start() {
        LOG.info("Starting proxy at address: " + this.requestedAddress);
        ServerGroup serverGroup = this.serverGroup;
        synchronized (serverGroup) {
            if (this.serverGroup.stopped) {
                throw new Error("Already stopped");
            }
            this.doStart();
        }
        return this;
    }

    private void doStart() {
        this.serverGroup.ensureProtocol(this.transportProtocol);
        ServerBootstrap serverBootstrap = new ServerBootstrap().group((EventLoopGroup)this.serverGroup.clientToProxyBossPools.get((Object)this.transportProtocol), (EventLoopGroup)this.serverGroup.clientToProxyWorkerPools.get((Object)this.transportProtocol));
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                new ClientToProxyConnection(DefaultHttpProxyServer.this, DefaultHttpProxyServer.this.sslEngineSource, DefaultHttpProxyServer.this.authenticateSslClients, ch.pipeline(), DefaultHttpProxyServer.this.globalTrafficShapingHandler);
            }
        };
        switch (this.transportProtocol) {
            case TCP: {
                LOG.info("Proxy listening with TCP transport");
                serverBootstrap.channelFactory((ChannelFactory)new ChannelFactory<ServerChannel>(){

                    public ServerChannel newChannel() {
                        return new NioServerSocketChannel();
                    }
                });
                break;
            }
            case UDT: {
                LOG.info("Proxy listening with UDT transport");
                ((ServerBootstrap)((ServerBootstrap)serverBootstrap.channelFactory(NioUdtProvider.BYTE_ACCEPTOR)).option(ChannelOption.SO_BACKLOG, (Object)10)).option(ChannelOption.SO_REUSEADDR, (Object)true);
                break;
            }
            default: {
                throw new UnknownTransportProtocolError(this.transportProtocol);
            }
        }
        serverBootstrap.childHandler((ChannelHandler)initializer);
        ChannelFuture future = serverBootstrap.bind((SocketAddress)this.requestedAddress).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    DefaultHttpProxyServer.this.registerChannel(future.channel());
                }
            }
        }).awaitUninterruptibly();
        Throwable cause = future.cause();
        if (cause != null) {
            throw new RuntimeException(cause);
        }
        this.boundAddress = (InetSocketAddress)future.channel().localAddress();
        LOG.info("Proxy started at address: " + this.boundAddress);
    }

    protected void registerChannel(Channel channel) {
        this.serverGroup.allChannels.add((Object)channel);
    }

    protected ChainedProxyManager getChainProxyManager() {
        return this.chainProxyManager;
    }

    protected MitmManager getMitmManager() {
        return this.mitmManager;
    }

    protected SslEngineSource getSslEngineSource() {
        return this.sslEngineSource;
    }

    protected ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public HttpFiltersSource getFiltersSource() {
        return this.filtersSource;
    }

    protected Collection<ActivityTracker> getActivityTrackers() {
        return this.activityTrackers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventLoopGroup getProxyToServerWorkerFor(TransportProtocol transportProtocol) {
        ServerGroup serverGroup = this.serverGroup;
        synchronized (serverGroup) {
            this.serverGroup.ensureProtocol(transportProtocol);
            return (EventLoopGroup)this.serverGroup.proxyToServerWorkerPools.get((Object)transportProtocol);
        }
    }

    private static class DefaultHttpProxyServerBootstrap
    implements HttpProxyServerBootstrap {
        private String name = "LittleProxy";
        private TransportProtocol transportProtocol = TransportProtocol.TCP;
        private InetSocketAddress requestedAddress;
        private int port = 8080;
        private boolean allowLocalOnly = true;
        private boolean listenOnAllAddresses = true;
        private SslEngineSource sslEngineSource = null;
        private boolean authenticateSslClients = true;
        private ProxyAuthenticator proxyAuthenticator = null;
        private ChainedProxyManager chainProxyManager = null;
        private MitmManager mitmManager = null;
        private HttpFiltersSource filtersSource = new HttpFiltersSourceAdapter();
        private boolean transparent = false;
        private int idleConnectionTimeout = 70;
        private DefaultHttpProxyServer original;
        private Collection<ActivityTracker> activityTrackers = new ConcurrentLinkedQueue<ActivityTracker>();
        private int connectTimeout = 40000;
        private HostResolver serverResolver = new DefaultHostResolver();
        private long readThrottleBytesPerSecond;
        private long writeThrottleBytesPerSecond;
        private InetSocketAddress localAddress;

        private DefaultHttpProxyServerBootstrap() {
        }

        private DefaultHttpProxyServerBootstrap(DefaultHttpProxyServer original, TransportProtocol transportProtocol, InetSocketAddress requestedAddress, SslEngineSource sslEngineSource, boolean authenticateSslClients, ProxyAuthenticator proxyAuthenticator, ChainedProxyManager chainProxyManager, MitmManager mitmManager, HttpFiltersSource filtersSource, boolean transparent, int idleConnectionTimeout, Collection<ActivityTracker> activityTrackers, int connectTimeout, HostResolver serverResolver, long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond, InetSocketAddress localAddress) {
            this.original = original;
            this.transportProtocol = transportProtocol;
            this.requestedAddress = requestedAddress;
            this.port = requestedAddress.getPort();
            this.sslEngineSource = sslEngineSource;
            this.authenticateSslClients = authenticateSslClients;
            this.proxyAuthenticator = proxyAuthenticator;
            this.chainProxyManager = chainProxyManager;
            this.mitmManager = mitmManager;
            this.filtersSource = filtersSource;
            this.transparent = transparent;
            this.idleConnectionTimeout = idleConnectionTimeout;
            if (activityTrackers != null) {
                this.activityTrackers.addAll(activityTrackers);
            }
            this.connectTimeout = connectTimeout;
            this.serverResolver = serverResolver;
            this.readThrottleBytesPerSecond = readThrottleBytesPerSecond;
            this.writeThrottleBytesPerSecond = writeThrottleBytesPerSecond;
            this.localAddress = localAddress;
        }

        private DefaultHttpProxyServerBootstrap(Properties props) {
            this.withUseDnsSec(ProxyUtils.extractBooleanDefaultFalse(props, "dnssec"));
            this.transparent = ProxyUtils.extractBooleanDefaultFalse(props, "transparent");
            this.idleConnectionTimeout = ProxyUtils.extractInt(props, "idle_connection_timeout");
            this.connectTimeout = ProxyUtils.extractInt(props, "connect_timeout", 0);
        }

        @Override
        public HttpProxyServerBootstrap withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withTransportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAddress(InetSocketAddress address) {
            this.requestedAddress = address;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withPort(int port) {
            this.requestedAddress = null;
            this.port = port;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withNetworkInterface(InetSocketAddress inetSocketAddress) {
            this.localAddress = inetSocketAddress;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAllowLocalOnly(boolean allowLocalOnly) {
            this.allowLocalOnly = allowLocalOnly;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withListenOnAllAddresses(boolean listenOnAllAddresses) {
            this.listenOnAllAddresses = listenOnAllAddresses;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withSslEngineSource(SslEngineSource sslEngineSource) {
            this.sslEngineSource = sslEngineSource;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAuthenticateSslClients(boolean authenticateSslClients) {
            this.authenticateSslClients = authenticateSslClients;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withProxyAuthenticator(ProxyAuthenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withChainProxyManager(ChainedProxyManager chainProxyManager) {
            this.chainProxyManager = chainProxyManager;
            if (this.mitmManager != null) {
                LOG.warn("Enabled proxy chaining with man in the middle.  These are mutually exclusive - man in the middle will be disabled.");
                this.mitmManager = null;
            }
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withManInTheMiddle(MitmManager mitmManager) {
            this.mitmManager = mitmManager;
            if (this.chainProxyManager != null) {
                LOG.warn("Enabled man in the middle along with proxy chaining.  These are mutually exclusive - proxy chaining will be disabled.");
                this.chainProxyManager = null;
            }
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withFiltersSource(HttpFiltersSource filtersSource) {
            this.filtersSource = filtersSource;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withUseDnsSec(boolean useDnsSec) {
            this.serverResolver = useDnsSec ? new DnsSecServerResolver() : new DefaultHostResolver();
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withTransparent(boolean transparent) {
            this.transparent = transparent;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withIdleConnectionTimeout(int idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withServerResolver(HostResolver serverResolver) {
            this.serverResolver = serverResolver;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap plusActivityTracker(ActivityTracker activityTracker) {
            this.activityTrackers.add(activityTracker);
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withThrottling(long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond) {
            this.readThrottleBytesPerSecond = readThrottleBytesPerSecond;
            this.writeThrottleBytesPerSecond = writeThrottleBytesPerSecond;
            return this;
        }

        @Override
        public HttpProxyServer start() {
            return this.build().start();
        }

        private DefaultHttpProxyServer build() {
            ServerGroup serverGroup = this.original != null ? this.original.serverGroup : new ServerGroup(this.name);
            return new DefaultHttpProxyServer(serverGroup, this.transportProtocol, this.determineListenAddress(), this.sslEngineSource, this.authenticateSslClients, this.proxyAuthenticator, this.chainProxyManager, this.mitmManager, this.filtersSource, this.transparent, this.idleConnectionTimeout, this.activityTrackers, this.connectTimeout, this.serverResolver, this.readThrottleBytesPerSecond, this.writeThrottleBytesPerSecond, this.localAddress);
        }

        private InetSocketAddress determineListenAddress() {
            if (this.requestedAddress != null) {
                return this.requestedAddress;
            }
            if (this.allowLocalOnly) {
                return new InetSocketAddress("127.0.0.1", this.port);
            }
            if (this.listenOnAllAddresses) {
                return new InetSocketAddress(this.port);
            }
            try {
                return new InetSocketAddress(NetworkUtils.getLocalHost(), this.port);
            }
            catch (UnknownHostException e) {
                LOG.error("Could not get local host?", (Throwable)e);
                return new InetSocketAddress(this.port);
            }
        }
    }

    private static class ServerGroup {
        private static final int INCOMING_ACCEPTOR_THREADS = 2;
        private static final int INCOMING_WORKER_THREADS = 8;
        private static final int OUTGOING_WORKER_THREADS = 8;
        private final String name;
        private final ChannelGroup allChannels = new DefaultChannelGroup("HTTP-Proxy-Server", (EventExecutor)GlobalEventExecutor.INSTANCE);
        private final Map<TransportProtocol, EventLoopGroup> clientToProxyBossPools = new HashMap<TransportProtocol, EventLoopGroup>();
        private final Map<TransportProtocol, EventLoopGroup> clientToProxyWorkerPools = new HashMap<TransportProtocol, EventLoopGroup>();
        private final Map<TransportProtocol, EventLoopGroup> proxyToServerWorkerPools = new HashMap<TransportProtocol, EventLoopGroup>();
        private volatile boolean stopped = false;
        private final Thread serverGroupShutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                ServerGroup.this.stop(false);
            }
        });

        private ServerGroup(String name) {
            this.name = name;
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.error("Uncaught throwable", e);
                }
            });
            Runtime.getRuntime().addShutdownHook(this.serverGroupShutdownHook);
        }

        public synchronized void ensureProtocol(TransportProtocol transportProtocol) {
            if (!this.clientToProxyWorkerPools.containsKey((Object)transportProtocol)) {
                this.initializeTransport(transportProtocol);
            }
        }

        private void initializeTransport(TransportProtocol transportProtocol) {
            SelectorProvider selectorProvider = null;
            switch (transportProtocol) {
                case TCP: {
                    selectorProvider = SelectorProvider.provider();
                    break;
                }
                case UDT: {
                    selectorProvider = NioUdtProvider.BYTE_PROVIDER;
                    break;
                }
                default: {
                    throw new UnknownTransportProtocolError(transportProtocol);
                }
            }
            NioEventLoopGroup inboundAcceptorGroup = new NioEventLoopGroup(2, (ThreadFactory)new CategorizedThreadFactory("ClientToProxyAcceptor"), selectorProvider);
            NioEventLoopGroup inboundWorkerGroup = new NioEventLoopGroup(8, (ThreadFactory)new CategorizedThreadFactory("ClientToProxyWorker"), selectorProvider);
            inboundWorkerGroup.setIoRatio(90);
            NioEventLoopGroup outboundWorkerGroup = new NioEventLoopGroup(8, (ThreadFactory)new CategorizedThreadFactory("ProxyToServerWorker"), selectorProvider);
            outboundWorkerGroup.setIoRatio(90);
            this.clientToProxyBossPools.put(transportProtocol, (EventLoopGroup)inboundAcceptorGroup);
            this.clientToProxyWorkerPools.put(transportProtocol, (EventLoopGroup)inboundWorkerGroup);
            this.proxyToServerWorkerPools.put(transportProtocol, (EventLoopGroup)outboundWorkerGroup);
        }

        private synchronized void stop(boolean graceful) {
            if (graceful) {
                LOG.info("Shutting down proxy gracefully");
            } else {
                LOG.info("Shutting down proxy immediately (non-graceful)");
            }
            if (this.stopped) {
                LOG.info("Already stopped");
                return;
            }
            LOG.info("Closing all channels...");
            ChannelGroupFuture future = this.allChannels.close();
            if (graceful) {
                future.awaitUninterruptibly(10000L);
                if (!future.isSuccess()) {
                    for (ChannelFuture cf : future) {
                        if (cf.isSuccess()) continue;
                        LOG.info("Unable to close channel.  Cause of failure for {} is {}", (Object)cf.channel(), (Object)cf.cause());
                    }
                }
            }
            LOG.info("Shutting down event loops");
            ArrayList<EventLoopGroup> allEventLoopGroups = new ArrayList<EventLoopGroup>();
            allEventLoopGroups.addAll(this.clientToProxyBossPools.values());
            allEventLoopGroups.addAll(this.clientToProxyWorkerPools.values());
            allEventLoopGroups.addAll(this.proxyToServerWorkerPools.values());
            for (EventLoopGroup group : allEventLoopGroups) {
                if (graceful) {
                    group.shutdownGracefully();
                    continue;
                }
                group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            }
            if (graceful) {
                for (EventLoopGroup group : allEventLoopGroups) {
                    try {
                        group.awaitTermination(60L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException ie) {
                        LOG.warn("Interrupted while shutting down event loop");
                    }
                }
            }
            try {
                Runtime.getRuntime().removeShutdownHook(this.serverGroupShutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.stopped = true;
            LOG.info("Done shutting down proxy");
        }

        private class CategorizedThreadFactory
        implements ThreadFactory {
            private String category;
            private int num = 0;

            public CategorizedThreadFactory(String category) {
                this.category = category;
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, ServerGroup.this.name + "-" + this.category + "-" + this.num++);
                return t;
            }
        }
    }
}

