/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm;

import com.google.common.collect.ObjectArrays;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import net.lightbody.bmp.mitm.exception.UncheckedIOException;
import net.lightbody.bmp.mitm.util.TrustUtil;

public class TrustSource {
    private static final TrustSource DEFAULT_TRUST_SOURCE = TrustSource.javaTrustSource().add(TrustSource.builtinTrustSource());
    private final X509Certificate[] trustedCAs;

    protected TrustSource() {
        this(TrustUtil.EMPTY_CERTIFICATE_ARRAY);
    }

    protected TrustSource(X509Certificate ... trustedCAs) {
        this.trustedCAs = trustedCAs == null ? TrustUtil.EMPTY_CERTIFICATE_ARRAY : trustedCAs;
    }

    public X509Certificate[] getTrustedCAs() {
        return this.trustedCAs;
    }

    public static TrustSource empty() {
        return new TrustSource();
    }

    public static TrustSource defaultTrustSource() {
        return DEFAULT_TRUST_SOURCE;
    }

    public static TrustSource builtinTrustSource() {
        return new TrustSource(TrustUtil.getBuiltinTrustedCAs());
    }

    public static TrustSource javaTrustSource() {
        return new TrustSource(TrustUtil.getJavaTrustedCAs());
    }

    public TrustSource add(String trustedPemEncodedCAs) {
        if (trustedPemEncodedCAs == null) {
            throw new IllegalArgumentException("PEM-encoded trusted CA String cannot be null");
        }
        X509Certificate[] trustedCertificates = TrustUtil.readX509CertificatesFromPem(trustedPemEncodedCAs);
        return this.add(trustedCertificates);
    }

    public TrustSource add(X509Certificate ... trustedCertificates) {
        if (trustedCertificates == null || trustedCertificates.length == 0) {
            return this;
        }
        X509Certificate[] newTrustedCAs = (X509Certificate[])ObjectArrays.concat((Object[])this.trustedCAs, (Object[])trustedCertificates, X509Certificate.class);
        return new TrustSource(newTrustedCAs);
    }

    public TrustSource add(KeyStore trustStore) {
        if (trustStore == null) {
            throw new IllegalArgumentException("Trust store cannot be null");
        }
        List<X509Certificate> trustedCertificates = TrustUtil.extractTrustedCertificateEntries(trustStore);
        return this.add(trustedCertificates.toArray(new X509Certificate[0]));
    }

    public TrustSource add(File trustedCAPemFile) {
        String pemFileContents;
        if (trustedCAPemFile == null) {
            throw new IllegalArgumentException("Trusted CA file cannot be null");
        }
        try {
            pemFileContents = Files.toString((File)trustedCAPemFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read file containing PEM-encoded trusted CAs: " + trustedCAPemFile.getAbsolutePath(), e);
        }
        return this.add(pemFileContents);
    }

    public TrustSource add(TrustSource trustSource) {
        if (trustSource == null) {
            throw new IllegalArgumentException("TrustSource cannot be null");
        }
        return this.add(trustSource.getTrustedCAs());
    }
}

