/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm;

import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import net.lightbody.bmp.mitm.CertificateInfo;
import net.lightbody.bmp.mitm.CertificateInfoGenerator;

public class HostnameCertificateInfoGenerator
implements CertificateInfoGenerator {
    private static final String DEFAULT_IMPERSONATED_CERT_ORG = "Impersonated Certificate";
    private static final String DEFAULT_IMPERSONATED_CERT_ORG_UNIT = "LittleProxy MITM";

    @Override
    public CertificateInfo generate(List<String> hostnames, X509Certificate originalCertificate) {
        if (hostnames == null || hostnames.size() < 1) {
            throw new IllegalArgumentException("Cannot create X.509 certificate without server hostname");
        }
        String commonName = hostnames.get(0);
        return new CertificateInfo().commonName(commonName).organization(DEFAULT_IMPERSONATED_CERT_ORG).organizationalUnit(DEFAULT_IMPERSONATED_CERT_ORG_UNIT).notBefore(this.getNotBefore()).notAfter(this.getNotAfter()).subjectAlternativeNames(hostnames);
    }

    protected Date getNotBefore() {
        return new Date(System.currentTimeMillis() - 31536000000L);
    }

    protected Date getNotAfter() {
        return new Date(System.currentTimeMillis() + 31536000000L);
    }
}

