package LinkFuture.Compressor;

import LinkFuture.Compressor.Model.CrunchFileInfo;
import LinkFuture.Compressor.Model.CrunchFileListInfo;
import LinkFuture.Compressor.Model.CrunchFileMetaInfo;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import jargs.gnu.CmdLineParser;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

import java.io.*;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 11/1/13
 * Time: 1:33 PM
 * To change this template use File | Settings | File Templates.
 */
public class LinkFutureCompressor {
    public static void main(String args[]) throws URISyntaxException {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option typeOpt = parser.addStringOption("type");
        CmdLineParser.Option xmlOpt = parser.addStringOption("xml");
        try {
            Utility.println("INFO ", "Start");
            parser.parse(args);
            String filePath = (String)parser.getOptionValue(xmlOpt);
            String compressType = (String)parser.getOptionValue(typeOpt);
            if (compressType == null || (!compressType.equalsIgnoreCase("js") && !compressType.equalsIgnoreCase("css"))) {
                usage();
                System.exit(1);
            }
            if (filePath == null) {
                usage();
                System.exit(1);
            }
            compressByXmlfile(compressType, filePath);

        } catch (Exception e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
            System.exit(1);
        }
    }

    static final String charset = "UTF-8";
    static final int linebreakpos = -1;                     //Insert a line break after the specified column number
    static final  boolean munge = true;                    //Place a mapping of munged identifiers to originals in this file
    static final boolean verbose = true;                  //Display informational messages and warnings
    static final boolean preserveAllSemiColons = true;    //Preserve all semicolons
    static final boolean disableOptimizations = false;

    public static void compressByXmlfile(String fileType, String xmlFilePath) throws IOException {
        CrunchFileMetaInfo meta = Utility.fromXml(Utility.getStringFromFile(xmlFilePath),CrunchFileMetaInfo.class);
        if(meta!=null && meta.CrunchFileListGroup!=null)
        {
            for (CrunchFileListInfo group:meta.CrunchFileListGroup)
            {
                 String outputFilePath = buildFilePath(xmlFilePath,group.OutputFilePath);
                 Utility.println("INFO ", "Compressing " + outputFilePath);
                  OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outputFilePath), charset);
                  if(group.CrunchFileList!=null)
                  {
                      for (CrunchFileInfo file:group.CrunchFileList)
                      {
                          String inputFilePath = buildFilePath(xmlFilePath,file.FilePath);
                          if(!file.minify)
                          {
                              out.write(Utility.getStringFromFile(inputFilePath));
                          }
                          else
                          {
                              compressFile(fileType,out,inputFilePath);
                          }

                      }
                  }
                out.close();
                Utility.println("SUCCESS", "Compressing file success");
            }
        }
    }

    public static String buildFilePath(String xmlFilePath, String filePath)
    {
         if(filePath.indexOf(":")>0)
         {
             return filePath;
         }
        String xmlFolder = Paths.get(xmlFilePath).getParent().toString();
        Path outputFilePath =  Paths.get(xmlFolder,filePath);
        File outputFileFolder = outputFilePath.getParent().toFile();
        if(!outputFileFolder.exists())
        {
            boolean success = outputFileFolder.mkdirs();
            if(!success)
            {
                throw new RuntimeException("Can't create folder: " + outputFileFolder.toString());
            }
        }
        return outputFilePath.toString();
    }
    public static void compressFile(String fileType,OutputStreamWriter out, String inputFilename) throws IOException {
        if(!new File(inputFilename).exists())
        {
            throw new IOException("Specific file :" + inputFilename + " not exist.");
        }
        final String localFilename = inputFilename;
        InputStreamReader in = null;
        try{
            in =new InputStreamReader(new FileInputStream(localFilename), charset);
            if(fileType.equalsIgnoreCase("js"))
            {
                JavaScriptCompressor compressor = new JavaScriptCompressor(in, new ErrorReporter() {
                    public void warning(String message, String sourceName,
                                        int line, String lineSource, int lineOffset) {
                        System.err.println("\n[WARNING] in " + localFilename);
                        if (line < 0) {
                            System.err.println("  " + message);
                        } else {
                            System.err.println("  " + line + ':' + lineOffset + ':' + message);
                        }
                    }

                    public void error(String message, String sourceName,
                                      int line, String lineSource, int lineOffset) {
                        System.err.println("[ERROR] in " + localFilename);
                        if (line < 0) {
                            System.err.println("  " + message);
                        } else {
                            System.err.println("  " + line + ':' + lineOffset + ':' + message);
                        }
                    }

                    public EvaluatorException runtimeError(String message, String sourceName,
                                                           int line, String lineSource, int lineOffset) {
                        error(message, sourceName, line, lineSource, lineOffset);
                        return new EvaluatorException(message);
                    }
                });
                //OutputStreamWriter mungemap = null;
                compressor.compress(out, linebreakpos, munge, verbose, preserveAllSemiColons,disableOptimizations);
                //if(mungemap!=null) mungemap.close();
            }
            if(fileType.equalsIgnoreCase("css"))
            {
                CssCompressor compressor = new CssCompressor(in);
                compressor.compress(out, linebreakpos);
            }
        }
        finally {
            if(in!=null)
            {
                in.close();
            }
        }
    }
    private static void usage() {
        System.err.println("Usage: java -jar yuicompressor.jar -type js|css -xml filePath");
    }
}
