package LinkFuture.Compressor;


import LinkFuture.Compressor.Model.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import java.io.*;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 11/1/13
 * Time: 4:18 PM
 * To change this template use File | Settings | File Templates.
 */
public class Utility {
    protected static final Logger logger = LoggerFactory.getLogger(Utility.class);


    public static<T> T fromXml(String xmlString,Class<T> targetClass)
    {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(targetClass);
            Unmarshaller jaxbUnmarshaller = context.createUnmarshaller();
            return (T) jaxbUnmarshaller.unmarshal(new StringReader(xmlString));
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        finally {
            context = null;
        }
        return null;
    }

    public static<T> String toXml(T obj)
    {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(obj.getClass());
            Marshaller m = context.createMarshaller();
            m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
//            m.setProperty("com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler",
//                    new CharacterEscapeHandler() {
//                        @Override
//                        public void escape(char[] ac, int i, int j, boolean flag,
//                                           Writer writer) throws IOException {
//                            writer.write(ac, i, j);
//                        }
//                    });

            StringWriter sw = new StringWriter();
            m.marshal(obj, sw);
            return sw.getBuffer().toString();
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        return null;
    }
    public static Boolean isNullOrEmpty(Object str){
        return str==null || str.toString().length()==0;
    }
    public static String trimStart(String input,String trimString)
    {
        if(input.startsWith(trimString))
        {
            return input.substring(trimString.length(),input.length());
        }
        return input;
    }
    public static String trimEnd(String input,String trimString)
    {
        if(input.endsWith(trimString))
        {
            int index = input.length() - trimString.length();
            return input.substring(0,index);
        }
        return input;
    }

    //region applicationPath
    private static String applicationPath;
    public synchronized static String getApplicationPath(){
        //return new File("").getAbsolutePath();
        //return PathExtensions.class.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        //http://stackoverflow.com/questions/218061/get-the-applications-path
        //return System.getProperty("user.dir");
        //can't use Debugger class, this class must design with no dependency
        if(isNullOrEmpty(applicationPath))
        {
            logger.trace("Getting application path");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if(classLoader==null || classLoader.getResource("")==null)
            {
                applicationPath = System.getProperty("user.dir");
                logger.trace("Can't find getEnclosingClass, use user.dir");
            }
            else
            {
                //noinspection ConstantConditions
                try {
                    String appPath  = Paths.get(classLoader.getResource("").toURI()).toString();
                    String webInfPath = System.getProperty("file.separator") + "WEB-INF" + System.getProperty("file.separator")  + "classes";
                    //web path , but not work if the class in *.war file
                    if(appPath.endsWith(webInfPath))
                    {
                        logger.trace("Use WEB-INF Path");
                        applicationPath = trimEnd(appPath,webInfPath);
                    }
                    else
                    {
                        applicationPath = System.getProperty("user.dir");
                    }
                } catch (URISyntaxException e) {
                    logger.error("classLoader.getResource('').toURI() exception",e);
                }

            }
            logger.trace(applicationPath);
        }
        return applicationPath;
    }
    public synchronized static void setApplicationPath(String path){
        applicationPath = path;
    }
    public static String getApplicationPath(String path){
       if(new File(path).isAbsolute())
       {
           return path;
       }
       return Paths.get(getApplicationPath(),path).toString();
    }
    //endregion

    public static String getStringFromUrl(String filePath) throws IOException {
        if(isWellFormedUriString(filePath))
        {
            return read(new InputStreamReader(new URL(filePath).openStream()));
        }
        return getStringFromFile(filePath);
    }
    public static Boolean isWellFormedUriString(String url){
        String filePathTemp = url.toLowerCase();
        return filePathTemp.startsWith("http://")
                ||filePathTemp.startsWith("https://")
                ||filePathTemp.startsWith("//");
    }
    public static String getStringFromFile(String filePath) throws IOException {
        filePath = getApplicationPath(filePath);
        File file = new File(filePath);
        if(file.exists())
        {
            return read(new FileReader(filePath));
        }
        throw new FileNotFoundException("Specific file not exist, " + filePath);
    }
    public static String read(Reader reader) throws IOException {
        try(BufferedReader  bufferedReader = new BufferedReader(reader)){
            StringBuilder sb = new StringBuilder();
            String lineString;
            while ((lineString = bufferedReader.readLine())!=null) {
                sb.append(lineString);
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    public synchronized static String getDetail(Exception ex)
    {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }


    public static String getJSUri(String fileName)
    {
        return getSiteUri(getJSConfigPath(fileName));
    }
    public static String getCssUri(String fileName)
    {
        return getSiteUri(getCssConfigPath(fileName));
    }
    public static String getSiteUri(String relativePath){
        if(isWellFormedUriString(relativePath))
        {
            return relativePath;
        }
        relativePath = relativePath.replace("\\","/");
        String contextPath = Config.getContextPath();
        if(relativePath.startsWith("/"))
        {
            return contextPath.concat(relativePath);
        }
        else
        {

            return contextPath.concat("/").concat(relativePath);
        }
    }
    public static String getJSConfigPath(String fileName)
    {
        if(isWellFormedUriString(fileName))
        {
            return fileName;
        }
        return Paths.get(Config.getJsFileFolder(), fileName).toString();
    }
    public static String getCssConfigPath(String fileName)
    {
        if(isWellFormedUriString(fileName))
        {
            return fileName;
        }
        return Paths.get(Config.getCssFileFolder(),fileName).toString();
    }

    private static String getISOTimeString(){
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date());
    }

    public static void println(String type, String msg){
        System.out.println(String.format("[%s] [%s] [LinkFuture.Compressor %s]: %s", getISOTimeString(),type,Config.version,msg));
    }
}
