/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Compressor;

import LinkFuture.Compressor.Model.CrunchFileInfo;
import LinkFuture.Compressor.Model.CrunchFileListInfo;
import LinkFuture.Compressor.Model.CrunchFileMetaInfo;
import LinkFuture.Compressor.Utility;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class LinkFutureCompressor {
    static final String charset = "UTF-8";
    static final int linebreakpos = -1;
    static final boolean munge = true;
    static final boolean verbose = true;
    static final boolean preserveAllSemiColons = true;
    static final boolean disableOptimizations = false;

    public static void main(String[] args) throws URISyntaxException {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option typeOpt = parser.addStringOption("type");
        CmdLineParser.Option xmlOpt = parser.addStringOption("xml");
        try {
            Utility.println("INFO ", "Start");
            parser.parse(args);
            String filePath = (String)parser.getOptionValue(xmlOpt);
            String compressType = (String)parser.getOptionValue(typeOpt);
            if (compressType == null || !compressType.equalsIgnoreCase("js") && !compressType.equalsIgnoreCase("css")) {
                LinkFutureCompressor.usage();
                System.exit(1);
            }
            if (filePath == null) {
                LinkFutureCompressor.usage();
                System.exit(1);
            }
            LinkFutureCompressor.compressByXmlfile(compressType, filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void compressByXmlfile(String fileType, String xmlFilePath) throws IOException {
        CrunchFileMetaInfo meta = Utility.fromXml(Utility.getStringFromFile(xmlFilePath), CrunchFileMetaInfo.class);
        if (meta != null && meta.CrunchFileListGroup != null) {
            for (CrunchFileListInfo group : meta.CrunchFileListGroup) {
                String outputFilePath = LinkFutureCompressor.buildFilePath(xmlFilePath, group.OutputFilePath);
                Utility.println("INFO ", "Compressing " + outputFilePath);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), charset);
                if (group.CrunchFileList != null) {
                    for (CrunchFileInfo file : group.CrunchFileList) {
                        String inputFilePath = LinkFutureCompressor.buildFilePath(xmlFilePath, file.FilePath);
                        if (!file.minify) {
                            out.write(Utility.getStringFromFile(inputFilePath));
                            continue;
                        }
                        LinkFutureCompressor.compressFile(fileType, out, inputFilePath);
                    }
                }
                out.close();
                Utility.println("SUCCESS", "Compressing file success");
            }
        }
    }

    public static String buildFilePath(String xmlFilePath, String filePath) {
        boolean success;
        if (filePath.indexOf(":") > 0) {
            return filePath;
        }
        String xmlFolder = Paths.get(xmlFilePath, new String[0]).getParent().toString();
        Path outputFilePath = Paths.get(xmlFolder, filePath);
        File outputFileFolder = outputFilePath.getParent().toFile();
        if (!outputFileFolder.exists() && !(success = outputFileFolder.mkdirs())) {
            throw new RuntimeException("Can't create folder: " + outputFileFolder.toString());
        }
        return outputFilePath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile(String fileType, OutputStreamWriter out, String inputFilename) throws IOException {
        if (!new File(inputFilename).exists()) {
            throw new IOException("Specific file :" + inputFilename + " not exist.");
        }
        final String localFilename = inputFilename;
        try (InputStreamReader in = null;){
            JavaScriptCompressor compressor;
            in = new InputStreamReader((InputStream)new FileInputStream(localFilename), charset);
            if (fileType.equalsIgnoreCase("js")) {
                compressor = new JavaScriptCompressor((Reader)in, new ErrorReporter(){

                    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        System.err.println("\n[WARNING] in " + localFilename);
                        if (line < 0) {
                            System.err.println("  " + message);
                        } else {
                            System.err.println("  " + line + ':' + lineOffset + ':' + message);
                        }
                    }

                    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        System.err.println("[ERROR] in " + localFilename);
                        if (line < 0) {
                            System.err.println("  " + message);
                        } else {
                            System.err.println("  " + line + ':' + lineOffset + ':' + message);
                        }
                    }

                    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        this.error(message, sourceName, line, lineSource, lineOffset);
                        return new EvaluatorException(message);
                    }
                });
                compressor.compress((Writer)out, -1, true, true, true, false);
            }
            if (fileType.equalsIgnoreCase("css")) {
                compressor = new CssCompressor((Reader)in);
                compressor.compress((Writer)out, -1);
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java -jar yuicompressor.jar -type js|css -xml filePath");
    }
}

