/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.Compressor;

import LinkFuture.Compressor.Model.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility {
    protected static final Logger logger = LoggerFactory.getLogger(Utility.class);
    private static String applicationPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromXml(String xmlString, Class<T> targetClass) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            Unmarshaller jaxbUnmarshaller = context.createUnmarshaller();
            Object object = jaxbUnmarshaller.unmarshal((Reader)new StringReader(xmlString));
            return (T)object;
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        finally {
            Object context = null;
        }
        return null;
    }

    public static <T> String toXml(T obj) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter sw = new StringWriter();
            m.marshal(obj, (Writer)sw);
            return sw.getBuffer().toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean isNullOrEmpty(Object str) {
        return str == null || str.toString().length() == 0;
    }

    public static String trimStart(String input, String trimString) {
        if (input.startsWith(trimString)) {
            return input.substring(trimString.length(), input.length());
        }
        return input;
    }

    public static String trimEnd(String input, String trimString) {
        if (input.endsWith(trimString)) {
            int index = input.length() - trimString.length();
            return input.substring(0, index);
        }
        return input;
    }

    public static synchronized String getApplicationPath() {
        if (Utility.isNullOrEmpty(applicationPath).booleanValue()) {
            logger.trace("Getting application path");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null || classLoader.getResource("") == null) {
                applicationPath = System.getProperty("user.dir");
                logger.trace("Can't find getEnclosingClass, use user.dir");
            } else {
                try {
                    String appPath = Paths.get(classLoader.getResource("").toURI()).toString();
                    String webInfPath = System.getProperty("file.separator") + "WEB-INF" + System.getProperty("file.separator") + "classes";
                    if (appPath.endsWith(webInfPath)) {
                        logger.trace("Use WEB-INF Path");
                        applicationPath = Utility.trimEnd(appPath, webInfPath);
                    } else {
                        applicationPath = System.getProperty("user.dir");
                    }
                }
                catch (URISyntaxException e) {
                    logger.error("classLoader.getResource('').toURI() exception", (Throwable)e);
                }
            }
            logger.trace(applicationPath);
        }
        return applicationPath;
    }

    public static synchronized void setApplicationPath(String path) {
        applicationPath = path;
    }

    public static String getApplicationPath(String path) {
        if (new File(path).isAbsolute()) {
            return path;
        }
        return Paths.get(Utility.getApplicationPath(), path).toString();
    }

    public static String getStringFromUrl(String filePath) throws IOException {
        if (Utility.isWellFormedUriString(filePath).booleanValue()) {
            return Utility.read(new InputStreamReader(new URL(filePath).openStream()));
        }
        return Utility.getStringFromFile(filePath);
    }

    public static Boolean isWellFormedUriString(String url) {
        String filePathTemp = url.toLowerCase();
        return filePathTemp.startsWith("http://") || filePathTemp.startsWith("https://") || filePathTemp.startsWith("//");
    }

    public static String getStringFromFile(String filePath) throws IOException {
        File file = new File(filePath = Utility.getApplicationPath(filePath));
        if (file.exists()) {
            return Utility.read(new FileReader(filePath));
        }
        throw new FileNotFoundException("Specific file not exist, " + filePath);
    }

    public static String read(Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String lineString;
            StringBuilder sb = new StringBuilder();
            while ((lineString = bufferedReader.readLine()) != null) {
                sb.append(lineString);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    public static synchronized String getDetail(Exception ex) {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public static String getJSUri(String fileName) {
        return Utility.getSiteUri(Utility.getJSConfigPath(fileName));
    }

    public static String getCssUri(String fileName) {
        return Utility.getSiteUri(Utility.getCssConfigPath(fileName));
    }

    public static String getSiteUri(String relativePath) {
        if (Utility.isWellFormedUriString(relativePath).booleanValue()) {
            return relativePath;
        }
        relativePath = relativePath.replace("\\", "/");
        String contextPath = Config.getContextPath();
        if (relativePath.startsWith("/")) {
            return contextPath.concat(relativePath);
        }
        return contextPath.concat("/").concat(relativePath);
    }

    public static String getJSConfigPath(String fileName) {
        if (Utility.isWellFormedUriString(fileName).booleanValue()) {
            return fileName;
        }
        return Paths.get(Config.getJsFileFolder(), fileName).toString();
    }

    public static String getCssConfigPath(String fileName) {
        if (Utility.isWellFormedUriString(fileName).booleanValue()) {
            return fileName;
        }
        return Paths.get(Config.getCssFileFolder(), fileName).toString();
    }

    private static String getISOTimeString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date());
    }

    public static void println(String type, String msg) {
        System.out.println(String.format("[%s] [%s] [LinkFuture.Compressor %s]: %s", Utility.getISOTimeString(), type, "2.2.1", msg));
    }
}

