package LinkFuture.EnvInjection;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import java.io.*;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 11/1/13
 * Time: 4:18 PM
 * To change this template use File | Settings | File Templates.
 */
public class Utility {
    public static<T> T fromXml(String xmlString,Class<T> targetClass)
    {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(targetClass);
            Unmarshaller jaxbUnmarshaller = context.createUnmarshaller();
            return (T) jaxbUnmarshaller.unmarshal(new StringReader(xmlString));
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        finally {
            context = null;
        }
        return null;
    }
    public static String getStringFromFile(String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        if(file.exists())
        {
            try(BufferedReader  bufferedReader = new BufferedReader(new FileReader(filePath))){
                StringBuilder sb = new StringBuilder();
                String lineString;
                while ((lineString = bufferedReader.readLine())!=null) {
                    sb.append(lineString);
                    sb.append("\n");
                }
                return sb.toString();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new FileNotFoundException("Specific file not exist, " + filePath);
    }
    public static boolean saveStringToFile(String filePath,String content,boolean isOverwrite) throws FileNotFoundException {
        File file = new File(filePath);
        if(file.exists())
        {
            if(isOverwrite)
            {
                //noinspection ResultOfMethodCallIgnored
                file.delete();
            }
            else
            {
                return false;
            }
        }
        boolean saved = false;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file))){
            bufferedWriter.write(content);
            saved = true;
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        return saved;
    }
    private static Map<String,Field> neverExpiredFieldObject = new ConcurrentHashMap<>();
    public static<T extends Annotation> Field findField(Class<?> type,Class<T> annotationClass) throws Exception {
        String classKey = "$Utility$findField".concat(type.getName()).concat(annotationClass.getName());
        if(!neverExpiredFieldObject.containsKey(classKey))
        {
            neverExpiredFieldObject.put(classKey,findFieldEx(type,annotationClass));
        }
        return neverExpiredFieldObject.get(classKey);
    }
    private static<T extends Annotation> Field findFieldEx(Class<?> type,Class<T> annotationClass){
        for (Field field:type.getDeclaredFields())
        {
            if(field.getAnnotation(annotationClass)!=null)
            {
                return field;
            }
        }
        throw new IllegalArgumentException("Specific ".concat(type.getName()).concat(" must have annotation ").concat(annotationClass.getName()));
    }
}
