/*
 * Decompiled with CFR 0.152.
 */
package LinkFuture.EnvInjection;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class Utility {
    private static Map<String, Field> neverExpiredFieldObject = new ConcurrentHashMap<String, Field>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromXml(String xmlString, Class<T> targetClass) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            Unmarshaller jaxbUnmarshaller = context.createUnmarshaller();
            Object object = jaxbUnmarshaller.unmarshal((Reader)new StringReader(xmlString));
            return (T)object;
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        finally {
            Object context = null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringFromFile(String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        if (!file.exists()) throw new FileNotFoundException("Specific file not exist, " + filePath);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(filePath));){
            String lineString;
            StringBuilder sb = new StringBuilder();
            while ((lineString = bufferedReader.readLine()) != null) {
                sb.append(lineString);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new FileNotFoundException("Specific file not exist, " + filePath);
    }

    public static boolean saveStringToFile(String filePath, String content, boolean isOverwrite) throws FileNotFoundException {
        File file = new File(filePath);
        if (file.exists()) {
            if (isOverwrite) {
                file.delete();
            } else {
                return false;
            }
        }
        boolean saved = false;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            bufferedWriter.write(content);
            saved = true;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return saved;
    }

    public static <T extends Annotation> Field findField(Class<?> type, Class<T> annotationClass) throws Exception {
        String classKey = "$Utility$findField".concat(type.getName()).concat(annotationClass.getName());
        if (!neverExpiredFieldObject.containsKey(classKey)) {
            neverExpiredFieldObject.put(classKey, Utility.findFieldEx(type, annotationClass));
        }
        return neverExpiredFieldObject.get(classKey);
    }

    private static <T extends Annotation> Field findFieldEx(Class<?> type, Class<T> annotationClass) {
        for (Field field : type.getDeclaredFields()) {
            if (field.getAnnotation(annotationClass) == null) continue;
            return field;
        }
        throw new IllegalArgumentException("Specific ".concat(type.getName()).concat(" must have annotation ").concat(annotationClass.getName()));
    }
}

