/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.minifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.logicsquad.minifier.MinificationException;
import net.logicsquad.minifier.Minifier;
import net.logicsquad.minifier.css.CSSMinifier;
import net.logicsquad.minifier.js.JSMinifier;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="minify", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class MinifierMojo
extends AbstractMojo {
    @Parameter(property="sourceDir", required=true)
    private String sourceDir;
    @Parameter(property="targetDir", required=true)
    private String targetDir;
    @Parameter(property="jsIncludes")
    private List<String> jsIncludes;
    @Parameter(property="jsExcludes")
    private List<String> jsExcludes;
    @Parameter(property="cssIncludes")
    private List<String> cssIncludes;
    @Parameter(property="cssExcludes")
    private List<String> cssExcludes;
    private List<String> jsFilenames;
    private List<String> cssFilenames;

    private List<String> jsFilenames() {
        if (this.jsFilenames == null) {
            this.jsFilenames = this.filenameList(this.jsIncludes, this.jsExcludes);
        }
        return this.jsFilenames;
    }

    private List<String> cssFilenames() {
        if (this.cssFilenames == null) {
            this.cssFilenames = this.filenameList(this.cssIncludes, this.cssExcludes);
        }
        return this.cssFilenames;
    }

    private List<String> filenameList(List<String> includes, List<String> excludes) {
        ArrayList<String> list = new ArrayList<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDir);
        scanner.setIncludes(includes.toArray(new String[0]));
        scanner.setExcludes(excludes.toArray(new String[0]));
        scanner.addDefaultExcludes();
        scanner.scan();
        for (String s : scanner.getIncludedFiles()) {
            list.add(s);
        }
        return list;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.minify(JSMinifier.class, this.jsFilenames());
        this.minify(CSSMinifier.class, this.cssFilenames());
    }

    private void minify(Class<? extends Minifier> minifierClass, List<String> filenames) throws MojoFailureException {
        for (String s : filenames) {
            try {
                File infile = new File(this.sourceDir, s);
                File outfile = new File(this.targetDir, s);
                Constructor<? extends Minifier> constructor = minifierClass.getConstructor(Reader.class);
                Minifier minifier = constructor.newInstance(new InputStreamReader(Files.newInputStream(infile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                Files.createDirectories(outfile.toPath().getParent(), new FileAttribute[0]);
                minifier.minify((Writer)new OutputStreamWriter(Files.newOutputStream(outfile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                this.logMinificationResult(s, infile, outfile);
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | MinificationException e) {
                throw new MojoFailureException("Unable to minify resources.", e);
            }
        }
    }

    private void logMinificationResult(String name, File infile, File outfile) {
        long pre = infile.length();
        long post = outfile.length();
        long reduction = (long)(100.0 - (double)post / (double)pre * 100.0);
        this.getLog().info((CharSequence)("Minified '" + name + "' " + pre + " -> " + post + " (" + reduction + "%)"));
    }
}

