/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.logicsquad.nanocaptcha.image.renderer.WordRenderer;

public class FastWordRenderer
implements WordRenderer {
    private static final int FONT_SIZE = 40;
    private static final int SHIFT = 20;
    private static final int FONT_INDEX_SIZE = 100;
    private static final int[] INDEXES = new int[100];
    private static AtomicInteger idxPointer = new AtomicInteger(0);
    private static final int FUDGE_MIN = -5;
    private static final int FUDGE_MAX = 5;
    private static final int FUDGE_INDEX_SIZE = 100;
    private static final int[] FUDGES = new int[100];
    private static AtomicInteger fudgePointer = new AtomicInteger(0);
    private static final Random RAND = new Random();
    private static final Color COLOR = Color.BLACK;
    private static final Font[] FONTS = new Font[2];
    private static final double YOFFSET = 0.25;
    private static final double XOFFSET = 0.05;

    public FastWordRenderer() {
        int i;
        for (i = 0; i < 100; ++i) {
            FastWordRenderer.INDEXES[i] = RAND.nextInt(FONTS.length);
        }
        for (i = 0; i < 100; ++i) {
            FastWordRenderer.FUDGES[i] = RAND.nextInt(11) + -5;
        }
    }

    @Override
    public void render(String word, BufferedImage image) {
        Graphics2D g = image.createGraphics();
        int xBaseline = (int)((double)image.getWidth() * 0.05);
        int yBaseline = image.getHeight() - (int)((double)image.getHeight() * 0.25);
        char[] chars = new char[1];
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c;
            chars[0] = c = cArray[i];
            g.setColor(COLOR);
            g.setFont(this.nextFont());
            int xFudge = this.nextFudge();
            int yFudge = this.nextFudge();
            g.drawChars(chars, 0, 1, xBaseline + xFudge, yBaseline - yFudge);
            xBaseline += 20;
        }
    }

    private Font nextFont() {
        if (FONTS.length == 1) {
            return FONTS[0];
        }
        return FONTS[INDEXES[idxPointer.getAndIncrement() % 100]];
    }

    private int nextFudge() {
        return FUDGES[fudgePointer.getAndIncrement() % 100];
    }

    static {
        FastWordRenderer.FONTS[0] = new Font("Arial", 1, 40);
        FastWordRenderer.FONTS[1] = new Font("Courier", 1, 40);
    }
}

