/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.backgrounds;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.logicsquad.nanocaptcha.image.backgrounds.BackgroundProducer;

public class GradiatedBackgroundProducer
implements BackgroundProducer {
    private static final Color DEFAULT_FROM_COLOR = Color.DARK_GRAY;
    private static final Color DEFAULT_TO_COLOR = Color.WHITE;
    private final Color fromColor;
    private final Color toColor;

    public GradiatedBackgroundProducer() {
        this(DEFAULT_FROM_COLOR, DEFAULT_TO_COLOR);
    }

    public GradiatedBackgroundProducer(Color fromColor, Color toColor) {
        this.fromColor = fromColor;
        this.toColor = toColor;
    }

    @Override
    public BufferedImage getBackground(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g = img.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHints(hints);
        GradientPaint ytow = new GradientPaint(0.0f, 0.0f, this.fromColor, width, height, this.toColor);
        g.setPaint(ytow);
        g.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return img;
    }
}

