/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.filter;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.util.Random;
import net.logicsquad.nanocaptcha.image.filter.ImageFilter;

public class RippleImageFilter
implements ImageFilter {
    @Override
    public void filter(BufferedImage image) {
        RippleFilter filter = new RippleFilter();
        filter.setWaveType(0);
        filter.setXAmplitude(2.6f);
        filter.setYAmplitude(1.7f);
        filter.setXWavelength(15.0f);
        filter.setYWavelength(5.0f);
        ImageFilter.applyFilter(image, filter);
    }

    private static interface Function1D {
        public float evaluate(float var1);
    }

    private static interface Function2D {
        public float evaluate(float var1, float var2);
    }

    private static interface Function3D {
        public float evaluate(float var1, float var2, float var3);
    }

    private static class Noise
    implements Function1D,
    Function2D,
    Function3D {
        private static Random randomGenerator = new Random();
        private static final int B = 256;
        private static final int BM = 255;
        private static final int N = 4096;
        static int[] p = new int[514];
        static float[][] g3 = new float[514][3];
        static float[][] g2 = new float[514][2];
        static float[] g1 = new float[514];
        static boolean start = true;

        private Noise() {
        }

        @Override
        public float evaluate(float x) {
            return Noise.noise1(x);
        }

        @Override
        public float evaluate(float x, float y) {
            return Noise.noise2(x, y);
        }

        @Override
        public float evaluate(float x, float y, float z) {
            return Noise.noise3(x, y, z);
        }

        private static float sCurve(float t) {
            return t * t * (3.0f - 2.0f * t);
        }

        public static float noise1(float x) {
            if (start) {
                start = false;
                Noise.init();
            }
            float t = x + 4096.0f;
            int bx0 = (int)t & 0xFF;
            int bx1 = bx0 + 1 & 0xFF;
            float rx0 = t - (float)((int)t);
            float rx1 = rx0 - 1.0f;
            float sx = Noise.sCurve(rx0);
            float u = rx0 * g1[p[bx0]];
            float v = rx1 * g1[p[bx1]];
            return 2.3f * Noise.lerp(sx, u, v);
        }

        public static float noise2(float x, float y) {
            if (start) {
                start = false;
                Noise.init();
            }
            float t = x + 4096.0f;
            int bx0 = (int)t & 0xFF;
            int bx1 = bx0 + 1 & 0xFF;
            float rx0 = t - (float)((int)t);
            float rx1 = rx0 - 1.0f;
            t = y + 4096.0f;
            int by0 = (int)t & 0xFF;
            int by1 = by0 + 1 & 0xFF;
            float ry0 = t - (float)((int)t);
            float ry1 = ry0 - 1.0f;
            int i = p[bx0];
            int j = p[bx1];
            int b00 = p[i + by0];
            int b10 = p[j + by0];
            int b01 = p[i + by1];
            int b11 = p[j + by1];
            float sx = Noise.sCurve(rx0);
            float sy = Noise.sCurve(ry0);
            float[] q = g2[b00];
            float u = rx0 * q[0] + ry0 * q[1];
            q = g2[b10];
            float v = rx1 * q[0] + ry0 * q[1];
            float a = Noise.lerp(sx, u, v);
            q = g2[b01];
            u = rx0 * q[0] + ry1 * q[1];
            q = g2[b11];
            v = rx1 * q[0] + ry1 * q[1];
            float b = Noise.lerp(sx, u, v);
            return 1.5f * Noise.lerp(sy, a, b);
        }

        public static float noise3(float x, float y, float z) {
            if (start) {
                start = false;
                Noise.init();
            }
            float t = x + 4096.0f;
            int bx0 = (int)t & 0xFF;
            int bx1 = bx0 + 1 & 0xFF;
            float rx0 = t - (float)((int)t);
            float rx1 = rx0 - 1.0f;
            t = y + 4096.0f;
            int by0 = (int)t & 0xFF;
            int by1 = by0 + 1 & 0xFF;
            float ry0 = t - (float)((int)t);
            float ry1 = ry0 - 1.0f;
            t = z + 4096.0f;
            int bz0 = (int)t & 0xFF;
            int bz1 = bz0 + 1 & 0xFF;
            float rz0 = t - (float)((int)t);
            float rz1 = rz0 - 1.0f;
            int i = p[bx0];
            int j = p[bx1];
            int b00 = p[i + by0];
            int b10 = p[j + by0];
            int b01 = p[i + by1];
            int b11 = p[j + by1];
            t = Noise.sCurve(rx0);
            float sy = Noise.sCurve(ry0);
            float sz = Noise.sCurve(rz0);
            float[] q = g3[b00 + bz0];
            float u = rx0 * q[0] + ry0 * q[1] + rz0 * q[2];
            q = g3[b10 + bz0];
            float v = rx1 * q[0] + ry0 * q[1] + rz0 * q[2];
            float a = Noise.lerp(t, u, v);
            q = g3[b01 + bz0];
            u = rx0 * q[0] + ry1 * q[1] + rz0 * q[2];
            q = g3[b11 + bz0];
            v = rx1 * q[0] + ry1 * q[1] + rz0 * q[2];
            float b = Noise.lerp(t, u, v);
            float c = Noise.lerp(sy, a, b);
            q = g3[b00 + bz1];
            u = rx0 * q[0] + ry0 * q[1] + rz1 * q[2];
            q = g3[b10 + bz1];
            v = rx1 * q[0] + ry0 * q[1] + rz1 * q[2];
            a = Noise.lerp(t, u, v);
            q = g3[b01 + bz1];
            u = rx0 * q[0] + ry1 * q[1] + rz1 * q[2];
            q = g3[b11 + bz1];
            v = rx1 * q[0] + ry1 * q[1] + rz1 * q[2];
            b = Noise.lerp(t, u, v);
            float d = Noise.lerp(sy, a, b);
            return 1.5f * Noise.lerp(sz, c, d);
        }

        public static float lerp(float t, float a, float b) {
            return a + t * (b - a);
        }

        private static void normalize2(float[] v) {
            float s = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1]);
            v[0] = v[0] / s;
            v[1] = v[1] / s;
        }

        static void normalize3(float[] v) {
            float s = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
            v[0] = v[0] / s;
            v[1] = v[1] / s;
            v[2] = v[2] / s;
        }

        private static int random() {
            return randomGenerator.nextInt() & Integer.MAX_VALUE;
        }

        private static void init() {
            int j;
            int i;
            for (i = 0; i < 256; ++i) {
                Noise.p[i] = i;
                Noise.g1[i] = (float)(Noise.random() % 512 - 256) / 256.0f;
                for (j = 0; j < 2; ++j) {
                    Noise.g2[i][j] = (float)(Noise.random() % 512 - 256) / 256.0f;
                }
                Noise.normalize2(g2[i]);
                for (j = 0; j < 3; ++j) {
                    Noise.g3[i][j] = (float)(Noise.random() % 512 - 256) / 256.0f;
                }
                Noise.normalize3(g3[i]);
            }
            for (i = 255; i >= 0; --i) {
                int k = p[i];
                j = Noise.random() % 256;
                Noise.p[i] = p[j];
                Noise.p[j] = k;
            }
            for (i = 0; i < 258; ++i) {
                Noise.p[256 + i] = p[i];
                Noise.g1[256 + i] = g1[i];
                for (j = 0; j < 2; ++j) {
                    Noise.g2[256 + i][j] = g2[i][j];
                }
                for (j = 0; j < 3; ++j) {
                    Noise.g3[256 + i][j] = g3[i][j];
                }
            }
        }
    }

    private static class ImageMath {
        private ImageMath() {
        }

        public static int clamp(int x, int a, int b) {
            return x < a ? a : (x > b ? b : x);
        }

        public static float mod(float a, float b) {
            int n;
            if ((a -= (float)(n = (int)(a / b)) * b) < 0.0f) {
                return a + b;
            }
            return a;
        }

        public static int mod(int a, int b) {
            int n;
            if ((a -= (n = a / b) * b) < 0) {
                return a + b;
            }
            return a;
        }

        public static float triangle(float x) {
            float r = ImageMath.mod(x, 1.0f);
            return 2.0f * ((double)r < 0.5 ? r : 1.0f - r);
        }

        public static int bilinearInterpolate(float x, float y, int nw, int ne, int sw, int se) {
            int a0 = nw >> 24 & 0xFF;
            int r0 = nw >> 16 & 0xFF;
            int g0 = nw >> 8 & 0xFF;
            int b0 = nw & 0xFF;
            int a1 = ne >> 24 & 0xFF;
            int r1 = ne >> 16 & 0xFF;
            int g1 = ne >> 8 & 0xFF;
            int b1 = ne & 0xFF;
            int a2 = sw >> 24 & 0xFF;
            int r2 = sw >> 16 & 0xFF;
            int g2 = sw >> 8 & 0xFF;
            int b2 = sw & 0xFF;
            int a3 = se >> 24 & 0xFF;
            int r3 = se >> 16 & 0xFF;
            int g3 = se >> 8 & 0xFF;
            int b3 = se & 0xFF;
            float cx = 1.0f - x;
            float cy = 1.0f - y;
            float m0 = cx * (float)a0 + x * (float)a1;
            float m1 = cx * (float)a2 + x * (float)a3;
            int a = (int)(cy * m0 + y * m1);
            m0 = cx * (float)r0 + x * (float)r1;
            m1 = cx * (float)r2 + x * (float)r3;
            int r = (int)(cy * m0 + y * m1);
            m0 = cx * (float)g0 + x * (float)g1;
            m1 = cx * (float)g2 + x * (float)g3;
            int g = (int)(cy * m0 + y * m1);
            m0 = cx * (float)b0 + x * (float)b1;
            m1 = cx * (float)b2 + x * (float)b3;
            int b = (int)(cy * m0 + y * m1);
            return a << 24 | r << 16 | g << 8 | b;
        }
    }

    private static abstract class AbstractBufferedImageOp
    implements BufferedImageOp,
    Cloneable {
        private AbstractBufferedImageOp() {
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
            if (dstCM == null) {
                dstCM = src.getColorModel();
            }
            return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), dstCM.isAlphaPremultiplied(), null);
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage src) {
            return new Rectangle(0, 0, src.getWidth(), src.getHeight());
        }

        @Override
        public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
            if (dstPt == null) {
                dstPt = new Point2D.Double();
            }
            dstPt.setLocation(srcPt.getX(), srcPt.getY());
            return dstPt;
        }

        @Override
        public abstract RenderingHints getRenderingHints();

        public int[] getRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
            int type = image.getType();
            if (type == 2 || type == 1) {
                return (int[])image.getRaster().getDataElements(x, y, width, height, pixels);
            }
            return image.getRGB(x, y, width, height, pixels, 0, width);
        }

        public void setRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
            int type = image.getType();
            if (type == 2 || type == 1) {
                image.getRaster().setDataElements(x, y, width, height, pixels);
            } else {
                image.setRGB(x, y, width, height, pixels, 0, width);
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static abstract class TransformFilter
    extends AbstractBufferedImageOp {
        public static final int ZERO = 0;
        public static final int CLAMP = 1;
        public static final int WRAP = 2;
        public static final int RGB_CLAMP = 3;
        public static final int NEAREST_NEIGHBOUR = 0;
        public static final int BILINEAR = 1;
        protected int edgeAction = 3;
        protected int interpolation = 1;
        protected Rectangle transformedSpace;

        private TransformFilter() {
        }

        protected abstract void transformInverse(int var1, int var2, float[] var3);

        protected abstract void transformSpace(Rectangle var1);

        @Override
        public BufferedImage filter(BufferedImage src, BufferedImage dst) {
            int width = src.getWidth();
            int height = src.getHeight();
            this.transformedSpace = new Rectangle(0, 0, width, height);
            this.transformSpace(this.transformedSpace);
            if (dst == null) {
                ColorModel dstCM = src.getColorModel();
                dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(this.transformedSpace.width, this.transformedSpace.height), dstCM.isAlphaPremultiplied(), null);
            }
            int[] inPixels = this.getRGB(src, 0, 0, width, height, null);
            if (this.interpolation == 0) {
                return this.filterPixelsNN(dst, width, height, inPixels, this.transformedSpace);
            }
            int srcWidth = width;
            int srcHeight = height;
            int srcWidth1 = width - 1;
            int srcHeight1 = height - 1;
            int outWidth = this.transformedSpace.width;
            int outHeight = this.transformedSpace.height;
            int[] outPixels = new int[outWidth];
            int outX = this.transformedSpace.x;
            int outY = this.transformedSpace.y;
            float[] out = new float[2];
            for (int y = 0; y < outHeight; ++y) {
                for (int x = 0; x < outWidth; ++x) {
                    int se;
                    int sw;
                    int ne;
                    int nw;
                    this.transformInverse(outX + x, outY + y, out);
                    int srcX = (int)Math.floor(out[0]);
                    int srcY = (int)Math.floor(out[1]);
                    float xWeight = out[0] - (float)srcX;
                    float yWeight = out[1] - (float)srcY;
                    if (srcX >= 0 && srcX < srcWidth1 && srcY >= 0 && srcY < srcHeight1) {
                        int i = srcWidth * srcY + srcX;
                        nw = inPixels[i];
                        ne = inPixels[i + 1];
                        sw = inPixels[i + srcWidth];
                        se = inPixels[i + srcWidth + 1];
                    } else {
                        nw = this.getPixel(inPixels, srcX, srcY, srcWidth, srcHeight);
                        ne = this.getPixel(inPixels, srcX + 1, srcY, srcWidth, srcHeight);
                        sw = this.getPixel(inPixels, srcX, srcY + 1, srcWidth, srcHeight);
                        se = this.getPixel(inPixels, srcX + 1, srcY + 1, srcWidth, srcHeight);
                    }
                    outPixels[x] = ImageMath.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
                }
                this.setRGB(dst, 0, y, this.transformedSpace.width, 1, outPixels);
            }
            return dst;
        }

        private final int getPixel(int[] pixels, int x, int y, int width, int height) {
            if (x < 0 || x >= width || y < 0 || y >= height) {
                switch (this.edgeAction) {
                    default: {
                        return 0;
                    }
                    case 2: {
                        return pixels[ImageMath.mod(y, height) * width + ImageMath.mod(x, width)];
                    }
                    case 1: {
                        return pixels[ImageMath.clamp(y, 0, height - 1) * width + ImageMath.clamp(x, 0, width - 1)];
                    }
                    case 3: 
                }
                return pixels[ImageMath.clamp(y, 0, height - 1) * width + ImageMath.clamp(x, 0, width - 1)] & 0xFFFFFF;
            }
            return pixels[y * width + x];
        }

        protected BufferedImage filterPixelsNN(BufferedImage dst, int width, int height, int[] inPixels, Rectangle transformedSpace) {
            int srcWidth = width;
            int srcHeight = height;
            int outWidth = transformedSpace.width;
            int outHeight = transformedSpace.height;
            int[] outPixels = new int[outWidth];
            int outX = transformedSpace.x;
            int outY = transformedSpace.y;
            float[] out = new float[2];
            for (int y = 0; y < outHeight; ++y) {
                for (int x = 0; x < outWidth; ++x) {
                    this.transformInverse(outX + x, outY + y, out);
                    int srcX = (int)out[0];
                    int srcY = (int)out[1];
                    if (out[0] < 0.0f || srcX >= srcWidth || out[1] < 0.0f || srcY >= srcHeight) {
                        int p;
                        switch (this.edgeAction) {
                            default: {
                                p = 0;
                                break;
                            }
                            case 2: {
                                p = inPixels[ImageMath.mod(srcY, srcHeight) * srcWidth + ImageMath.mod(srcX, srcWidth)];
                                break;
                            }
                            case 1: {
                                p = inPixels[ImageMath.clamp(srcY, 0, srcHeight - 1) * srcWidth + ImageMath.clamp(srcX, 0, srcWidth - 1)];
                                break;
                            }
                            case 3: {
                                p = inPixels[ImageMath.clamp(srcY, 0, srcHeight - 1) * srcWidth + ImageMath.clamp(srcX, 0, srcWidth - 1)] & 0xFFFFFF;
                            }
                        }
                        outPixels[x] = p;
                        continue;
                    }
                    int i = srcWidth * srcY + srcX;
                    outPixels[x] = inPixels[i];
                }
                this.setRGB(dst, 0, y, transformedSpace.width, 1, outPixels);
            }
            return dst;
        }
    }

    private static class RippleFilter
    extends TransformFilter {
        public static final int SINE = 0;
        public static final int SAWTOOTH = 1;
        public static final int TRIANGLE = 2;
        public static final int NOISE = 3;
        private float xAmplitude = 5.0f;
        private float yAmplitude = 0.0f;
        private float xWavelength = 16.0f;
        private float yWavelength = 16.0f;
        private int waveType;

        public void setXAmplitude(float xAmplitude) {
            this.xAmplitude = xAmplitude;
        }

        public void setXWavelength(float xWavelength) {
            this.xWavelength = xWavelength;
        }

        public void setYAmplitude(float yAmplitude) {
            this.yAmplitude = yAmplitude;
        }

        public void setYWavelength(float yWavelength) {
            this.yWavelength = yWavelength;
        }

        public void setWaveType(int waveType) {
            this.waveType = waveType;
        }

        @Override
        protected void transformSpace(Rectangle r) {
            if (this.edgeAction == 0) {
                r.x -= (int)this.xAmplitude;
                r.width += (int)(2.0f * this.xAmplitude);
                r.y -= (int)this.yAmplitude;
                r.height += (int)(2.0f * this.yAmplitude);
            }
        }

        @Override
        protected void transformInverse(int x, int y, float[] out) {
            float fy;
            float fx;
            float nx = (float)y / this.xWavelength;
            float ny = (float)x / this.yWavelength;
            switch (this.waveType) {
                default: {
                    fx = (float)Math.sin(nx);
                    fy = (float)Math.sin(ny);
                    break;
                }
                case 1: {
                    fx = ImageMath.mod(nx, 1.0f);
                    fy = ImageMath.mod(ny, 1.0f);
                    break;
                }
                case 2: {
                    fx = ImageMath.triangle(nx);
                    fy = ImageMath.triangle(ny);
                    break;
                }
                case 3: {
                    fx = Noise.noise1(nx);
                    fy = Noise.noise1(ny);
                }
            }
            out[0] = (float)x + this.xAmplitude * fx;
            out[1] = (float)y + this.yAmplitude * fy;
        }

        public String toString() {
            return "Distort/Ripple...";
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }
    }
}

