/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.logicsquad.nanocaptcha.image.renderer.AbstractWordRenderer;

public final class FastWordRenderer
extends AbstractWordRenderer {
    private static final int SHIFT = 20;
    private static final int FONT_INDEX_SIZE = 100;
    private static final int[] INDEXES;
    private static AtomicInteger idxPointer;
    private static final int FUDGE_MIN = -5;
    private static final int FUDGE_MAX = 5;
    private static final int FUDGE_INDEX_SIZE = 100;
    private static final int[] FUDGES;
    private static AtomicInteger fudgePointer;
    private static final Font[] FONTS;

    private FastWordRenderer(double xOffset, double yOffset, Supplier<Color> wordColorSupplier, Supplier<Font> fontSupplier) {
        super(xOffset, yOffset, wordColorSupplier, fontSupplier);
    }

    @Override
    public void render(String word, BufferedImage image) {
        Graphics2D g = image.createGraphics();
        int xBaseline = (int)((double)image.getWidth() * this.xOffset());
        int yBaseline = image.getHeight() - (int)((double)image.getHeight() * this.yOffset());
        char[] chars = new char[1];
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c;
            chars[0] = c = cArray[i];
            g.setColor(this.colorSupplier().get());
            g.setFont(this.nextFont());
            int xFudge = this.nextFudge();
            int yFudge = this.nextFudge();
            g.drawChars(chars, 0, 1, xBaseline + xFudge, yBaseline - yFudge);
            xBaseline += 20;
        }
    }

    private Font nextFont() {
        if (FONTS.length == 1) {
            return FONTS[0];
        }
        return FONTS[INDEXES[idxPointer.getAndIncrement() % 100]];
    }

    private int nextFudge() {
        return FUDGES[fudgePointer.getAndIncrement() % 100];
    }

    static {
        int i;
        INDEXES = new int[100];
        idxPointer = new AtomicInteger(0);
        FUDGES = new int[100];
        fudgePointer = new AtomicInteger(0);
        FONTS = new Font[2];
        FastWordRenderer.FONTS[0] = (Font)DEFAULT_FONTS.get(0);
        FastWordRenderer.FONTS[1] = (Font)DEFAULT_FONTS.get(1);
        for (i = 0; i < 100; ++i) {
            FastWordRenderer.INDEXES[i] = RAND.nextInt(FONTS.length);
        }
        for (i = 0; i < 100; ++i) {
            FastWordRenderer.FUDGES[i] = RAND.nextInt(11) + -5;
        }
    }

    public static class Builder
    extends AbstractWordRenderer.Builder {
        @Override
        public FastWordRenderer build() {
            return new FastWordRenderer(this.xOffset, this.yOffset, this.colorSupplier, this.fontSupplier);
        }
    }
}

