/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import net.logstash.logback.LogstashFormatter;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonParseException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonProcessingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonNode;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.ObjectMapper;
import net.logstash.logback.encoder.org.apache.commons.io.IOUtils;

public class LogstashEncoder
extends EncoderBase<ILoggingEvent> {
    private boolean immediateFlush = true;
    private final LogstashFormatter formatter = new LogstashFormatter();

    public void doEncode(ILoggingEvent event) throws IOException {
        IOUtils.write(this.formatter.writeValueAsBytes(event, this.getContext()), this.outputStream);
        IOUtils.write(CoreConstants.LINE_SEPARATOR, this.outputStream);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        IOUtils.write(IOUtils.LINE_SEPARATOR, this.outputStream);
    }

    public static JsonNode parseCustomFields(String customFields) throws JsonParseException, JsonProcessingException, IOException {
        return (JsonNode)new ObjectMapper().getFactory().createParser(customFields).readValueAsTree();
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public boolean isIncludeCallerInfo() {
        return this.formatter.isIncludeCallerInfo();
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.formatter.setIncludeCallerInfo(includeCallerInfo);
    }

    public void setCustomFields(String customFields) {
        try {
            this.formatter.setCustomFields(LogstashEncoder.parseCustomFields(customFields));
        }
        catch (JsonParseException e) {
            this.addError("Failed to parse custom fields [" + customFields + "]", e);
        }
        catch (JsonProcessingException e) {
            this.addError("Failed to parse custom fields [" + customFields + "]", e);
        }
        catch (IOException e) {
            this.addError("Failed to parse custom fields [" + customFields + "]", e);
        }
    }

    public JsonNode getCustomFields() {
        return this.formatter.getCustomFields();
    }
}

