/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Context;
import java.io.IOException;
import java.util.Map;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonGenerator;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.ObjectMapper;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.node.ObjectNode;
import net.logstash.logback.encoder.org.apache.commons.lang.time.FastDateFormat;

public class LogstashAccessFormatter {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    private static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    public byte[] writeValueAsBytes(IAccessEvent event, Context context) throws IOException {
        return MAPPER.writeValueAsBytes(this.eventToNode(event, context));
    }

    public String writeValueAsString(IAccessEvent event, Context context) throws IOException {
        return MAPPER.writeValueAsString(this.eventToNode(event, context));
    }

    private ObjectNode eventToNode(IAccessEvent event, Context context) {
        ObjectNode eventNode = MAPPER.createObjectNode();
        eventNode.put("@timestamp", ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeStamp()));
        eventNode.put("@version", 1);
        eventNode.put("@message", String.format("%s - %s [%s] \"%s\" %s %s", event.getRemoteHost(), event.getRemoteUser() == null ? "-" : event.getRemoteUser(), ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeStamp()), event.getRequestURL(), event.getStatusCode(), event.getContentLength()));
        this.createFields(event, context, eventNode);
        return eventNode;
    }

    private void createFields(IAccessEvent event, Context context, ObjectNode eventNode) {
        eventNode.put("@fields.method", event.getMethod());
        eventNode.put("@fields.protocol", event.getProtocol());
        eventNode.put("@fields.status_code", event.getStatusCode());
        eventNode.put("@fields.requested_url", event.getRequestURL());
        eventNode.put("@fields.requested_uri", event.getRequestURI());
        eventNode.put("@fields.remote_host", event.getRemoteHost());
        eventNode.put("@fields.HOSTNAME", event.getRemoteHost());
        eventNode.put("@fields.remote_user", event.getRemoteUser());
        eventNode.put("@fields.content_length", event.getContentLength());
        if (context != null) {
            this.addPropertiesAsFields(eventNode, context.getCopyOfPropertyMap());
        }
    }

    private void addPropertiesAsFields(ObjectNode fieldsNode, Map<String, String> properties) {
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                fieldsNode.put(key, value);
            }
        }
    }
}

