/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.Context;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonGenerator;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonNode;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.ObjectMapper;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.node.ArrayNode;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.node.ObjectNode;
import net.logstash.logback.encoder.org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Marker;

public class LogstashFormatter {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    private static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final StackTraceElement DEFAULT_CALLER_DATA = new StackTraceElement("", "", "", 0);
    private boolean includeCallerInfo;
    private JsonNode customFields;

    public LogstashFormatter() {
        this(false);
    }

    public LogstashFormatter(boolean includeCallerInfo) {
        this.includeCallerInfo = includeCallerInfo;
    }

    public LogstashFormatter(boolean includeCallerInfo, JsonNode customFields) {
        this.includeCallerInfo = includeCallerInfo;
        this.customFields = customFields;
    }

    public byte[] writeValueAsBytes(ILoggingEvent event, Context context) throws IOException {
        return MAPPER.writeValueAsBytes(this.eventToNode(event, context));
    }

    public String writeValueAsString(ILoggingEvent event, Context context) throws IOException {
        return MAPPER.writeValueAsString(this.eventToNode(event, context));
    }

    private ObjectNode eventToNode(ILoggingEvent event, Context context) {
        ObjectNode eventNode = MAPPER.createObjectNode();
        eventNode.put("@timestamp", ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeStamp()));
        eventNode.put("@version", 1);
        eventNode.put("message", event.getFormattedMessage());
        this.createFields(event, context, eventNode);
        eventNode.put("tags", this.createTags(event));
        return eventNode;
    }

    private void createFields(ILoggingEvent event, Context context, ObjectNode eventNode) {
        IThrowableProxy throwableProxy;
        Marker marker = event.getMarker();
        eventNode.put("logger_name", event.getLoggerName());
        eventNode.put("thread_name", event.getThreadName());
        eventNode.put("level", event.getLevel().toString());
        eventNode.put("level_value", event.getLevel().toInt());
        if (this.includeCallerInfo) {
            StackTraceElement callerData = this.extractCallerData(event);
            eventNode.put("caller_class_name", callerData.getClassName());
            eventNode.put("caller_method_name", callerData.getMethodName());
            eventNode.put("caller_file_name", callerData.getFileName());
            eventNode.put("caller_line_number", callerData.getLineNumber());
        }
        if ((throwableProxy = event.getThrowableProxy()) != null) {
            eventNode.put("stack_trace", ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy));
        }
        if (context != null) {
            this.addPropertiesAsFields(eventNode, context.getCopyOfPropertyMap());
        }
        if (marker != null && marker.contains("JSON")) {
            eventNode.put("json_message", this.getJsonNode(event));
        }
        this.addPropertiesAsFields(eventNode, event.getMDCPropertyMap());
        this.addCustomFields(eventNode);
    }

    private ArrayNode createTags(ILoggingEvent event) {
        ArrayNode node = null;
        Marker marker = event.getMarker();
        if (marker != null) {
            node = MAPPER.createArrayNode();
            if (!marker.getName().equals("JSON")) {
                node.add(marker.getName());
            }
            if (marker.hasReferences()) {
                for (Marker next : event.getMarker()) {
                    if (marker.getName().equals("JSON")) continue;
                    node.add(next.getName());
                }
            }
        }
        return node;
    }

    private void addPropertiesAsFields(ObjectNode fieldsNode, Map<String, String> properties) {
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                fieldsNode.put(key, value);
            }
        }
    }

    private JsonNode getJsonNode(ILoggingEvent event) {
        Object[] args = event.getArgumentArray();
        return MAPPER.convertValue((Object)args, JsonNode.class);
    }

    private StackTraceElement extractCallerData(ILoggingEvent event) {
        StackTraceElement[] ste = event.getCallerData();
        if (ste == null || ste.length == 0) {
            return DEFAULT_CALLER_DATA;
        }
        return ste[0];
    }

    private void addCustomFields(ObjectNode eventNode) {
        if (this.customFields != null) {
            Iterator<String> i = this.customFields.fieldNames();
            while (i.hasNext()) {
                String k = i.next();
                JsonNode v = this.customFields.get(k);
                eventNode.put(k, v);
            }
        }
    }

    public boolean isIncludeCallerInfo() {
        return this.includeCallerInfo;
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.includeCallerInfo = includeCallerInfo;
    }

    public void setCustomFields(JsonNode customFields) {
        this.customFields = customFields;
    }

    public JsonNode getCustomFields() {
        return this.customFields;
    }
}

