/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonFactory;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonGenerationException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonGenerator;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonParseException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonProcessingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.io.SegmentedStringWriter;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.util.BufferRecycler;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonMappingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonNode;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.MappingJsonFactory;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.ObjectMapper;
import net.logstash.logback.encoder.org.apache.commons.lang.time.FastDateFormat;
import net.logstash.logback.marker.LogstashMarker;
import org.slf4j.Marker;

public class LogstashFormatter {
    @Deprecated
    private static final String JSON_MARKER_NAME = "JSON";
    private static final JsonFactory FACTORY = new MappingJsonFactory().enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final StackTraceElement DEFAULT_CALLER_DATA = new StackTraceElement("", "", "", 0);
    private boolean includeCallerInfo;
    @Deprecated
    private boolean enableContextMap;
    private JsonNode customFields;
    private final ThreadLocal<SoftReference<BufferRecycler>> recycler = new ThreadLocal<SoftReference<BufferRecycler>>(){

        @Override
        protected SoftReference<BufferRecycler> initialValue() {
            BufferRecycler bufferRecycler = new BufferRecycler();
            return new SoftReference<BufferRecycler>(bufferRecycler);
        }
    };

    public LogstashFormatter() {
        this(false);
    }

    public LogstashFormatter(boolean includeCallerInfo) {
        this.includeCallerInfo = includeCallerInfo;
    }

    public LogstashFormatter(boolean includeCallerInfo, JsonNode customFields) {
        this.includeCallerInfo = includeCallerInfo;
        this.customFields = customFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeValueAsBytes(ILoggingEvent event, Context context) throws IOException {
        ByteArrayBuilder outputStream = new ByteArrayBuilder(this.getBufferRecycler());
        try {
            this.writeValueToOutputStream(event, context, outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            outputStream.release();
        }
    }

    public void writeValueToOutputStream(ILoggingEvent event, Context context, OutputStream outputStream) throws IOException {
        JsonGenerator generator = FACTORY.createGenerator(outputStream);
        this.writeValueToGenerator(generator, event, context);
    }

    public String writeValueAsString(ILoggingEvent event, Context context) throws IOException {
        SegmentedStringWriter writer = new SegmentedStringWriter(this.getBufferRecycler());
        JsonGenerator generator = FACTORY.createGenerator(writer);
        this.writeValueToGenerator(generator, event, context);
        return writer.getAndClear();
    }

    private void writeValueToGenerator(JsonGenerator generator, ILoggingEvent event, Context context) throws IOException {
        generator.writeStartObject();
        this.writeLogstashFields(generator, event);
        this.writeLoggerFields(generator, event);
        this.writeCallerDataFieldsIfNecessary(generator, event);
        this.writeStackTraceFieldIfNecessary(generator, event);
        this.writeContextPropertiesIfNecessary(generator, context);
        this.writeJsonMessageFieldIfNecessary(generator, event);
        this.writeMdcPropertiesIfNecessary(generator, event);
        this.writeContextMapFieldsIfNecessary(generator, event);
        this.writeGlobalCustomFields(generator);
        this.writeTagsIfNecessary(generator, event);
        this.writeLogstashMarkerIfNecessary(generator, event.getMarker());
        generator.writeEndObject();
        generator.flush();
    }

    private void writeLogstashFields(JsonGenerator generator, ILoggingEvent event) throws IOException {
        generator.writeStringField("@timestamp", ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeStamp()));
        generator.writeNumberField("@version", 1);
        generator.writeStringField("message", event.getFormattedMessage());
    }

    private void writeLoggerFields(JsonGenerator generator, ILoggingEvent event) throws IOException {
        generator.writeStringField("logger_name", event.getLoggerName());
        generator.writeStringField("thread_name", event.getThreadName());
        generator.writeStringField("level", event.getLevel().toString());
        generator.writeNumberField("level_value", event.getLevel().toInt());
    }

    private void writeCallerDataFieldsIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        if (this.includeCallerInfo) {
            StackTraceElement callerData = this.extractCallerData(event);
            generator.writeStringField("caller_class_name", callerData.getClassName());
            generator.writeStringField("caller_method_name", callerData.getMethodName());
            generator.writeStringField("caller_file_name", callerData.getFileName());
            generator.writeNumberField("caller_line_number", callerData.getLineNumber());
        }
    }

    private void writeStackTraceFieldIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null) {
            generator.writeStringField("stack_trace", ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy));
        }
    }

    private void writeContextPropertiesIfNecessary(JsonGenerator generator, Context context) throws IOException {
        if (context != null) {
            this.writeMapEntries(generator, context.getCopyOfPropertyMap());
        }
    }

    @Deprecated
    private void writeJsonMessageFieldIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        Marker marker = event.getMarker();
        if (marker != null && marker.contains(JSON_MARKER_NAME)) {
            generator.writeFieldName("json_message");
            MAPPER.writeValue(generator, (Object)event.getArgumentArray());
        }
    }

    private void writeMdcPropertiesIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        this.writeMapEntries(generator, event.getMDCPropertyMap());
    }

    @Deprecated
    private void writeContextMapFieldsIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        Object[] args;
        if (this.enableContextMap && (args = event.getArgumentArray()) != null && args.length > 0 && args[args.length - 1] instanceof Map) {
            Map contextMap = (Map)args[args.length - 1];
            this.writeMapEntries(generator, contextMap);
        }
    }

    private void writeMapEntries(JsonGenerator generator, Map<?, ?> map) throws IOException, JsonGenerationException, JsonMappingException {
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                MAPPER.writeValue(generator, entry.getValue());
            }
        }
    }

    private void writeGlobalCustomFields(JsonGenerator generator) throws IOException {
        this.writeFieldsOfNode(generator, this.customFields);
    }

    private void writeTagsIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        boolean hasWrittenStart = false;
        Marker marker = event.getMarker();
        if (marker != null) {
            hasWrittenStart = this.writeTagIfNecessary(generator, hasWrittenStart, marker);
        }
        if (hasWrittenStart) {
            generator.writeEndArray();
        }
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, Marker marker) throws IOException {
        if (!marker.getName().equals(JSON_MARKER_NAME) && !this.isLogstashMarker(marker)) {
            if (!hasWrittenStart) {
                generator.writeArrayFieldStart("tags");
                hasWrittenStart = true;
            }
            generator.writeString(marker.getName());
        }
        if (marker.hasReferences()) {
            for (Marker next : marker) {
                hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, next);
            }
        }
        return hasWrittenStart;
    }

    private boolean isLogstashMarker(Marker marker) {
        return marker instanceof LogstashMarker;
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, Marker marker) throws IOException {
        if (marker != null) {
            if (this.isLogstashMarker(marker)) {
                ((LogstashMarker)marker).writeTo(generator, MAPPER);
            }
            if (marker.hasReferences()) {
                for (Marker next : marker) {
                    this.writeLogstashMarkerIfNecessary(generator, next);
                }
            }
        }
    }

    private StackTraceElement extractCallerData(ILoggingEvent event) {
        StackTraceElement[] ste = event.getCallerData();
        if (ste == null || ste.length == 0) {
            return DEFAULT_CALLER_DATA;
        }
        return ste[0];
    }

    private void writeFieldsOfNode(JsonGenerator generator, JsonNode node) throws IOException {
        if (node != null) {
            Iterator<Map.Entry<String, JsonNode>> fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field = fields.next();
                generator.writeFieldName(field.getKey());
                generator.writeTree(field.getValue());
            }
        }
    }

    public boolean isIncludeCallerInfo() {
        return this.includeCallerInfo;
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.includeCallerInfo = includeCallerInfo;
    }

    public static JsonNode parseCustomFields(String customFields) throws JsonParseException, JsonProcessingException, IOException {
        return (JsonNode)FACTORY.createParser(customFields).readValueAsTree();
    }

    public void setCustomFieldsFromString(String customFields, ContextAware contextAware) {
        try {
            this.setCustomFields(LogstashFormatter.parseCustomFields(customFields));
        }
        catch (IOException e) {
            contextAware.addError("Failed to parse custom fields [" + customFields + "]", (Throwable)e);
        }
    }

    public void setCustomFields(JsonNode customFields) {
        this.customFields = customFields;
    }

    public JsonNode getCustomFields() {
        return this.customFields;
    }

    @Deprecated
    public boolean isEnableContextMap() {
        return this.enableContextMap;
    }

    @Deprecated
    public void setEnableContextMap(boolean enableContextMap) {
        this.enableContextMap = enableContextMap;
    }

    private BufferRecycler getBufferRecycler() {
        SoftReference<BufferRecycler> bufferRecyclerReference = this.recycler.get();
        BufferRecycler bufferRecycler = bufferRecyclerReference.get();
        if (bufferRecycler == null) {
            this.recycler.remove();
            return this.getBufferRecycler();
        }
        return bufferRecycler;
    }
}

