/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonParser;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonToken;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationContext;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationFeature;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonMappingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public class StackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;

    public StackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            String className = "";
            String methodName = "";
            String fileName = "";
            int lineNumber = -1;
            while ((t = jp.nextValue()) != JsonToken.END_OBJECT) {
                String propName = jp.getCurrentName();
                if ("className".equals(propName)) {
                    className = jp.getText();
                    continue;
                }
                if ("fileName".equals(propName)) {
                    fileName = jp.getText();
                    continue;
                }
                if ("lineNumber".equals(propName)) {
                    if (t.isNumeric()) {
                        lineNumber = jp.getIntValue();
                        continue;
                    }
                    throw JsonMappingException.from(jp, "Non-numeric token (" + (Object)((Object)t) + ") for property 'lineNumber'");
                }
                if ("methodName".equals(propName)) {
                    methodName = jp.getText();
                    continue;
                }
                if ("nativeMethod".equals(propName)) continue;
                this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
            }
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            StackTraceElement value = this.deserialize(jp, ctxt);
            if (jp.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'java.lang.StackTraceElement' value but there was more than a single value in the array");
            }
            return value;
        }
        throw ctxt.mappingException(this._valueClass, t);
    }
}

