/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonGenerator;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonNode;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.ObjectMapper;
import net.logstash.logback.encoder.org.apache.commons.lang.ObjectUtils;
import net.logstash.logback.marker.LogstashMarker;

public class ObjectFieldsAppendingMarker
extends LogstashMarker {
    public static final String MARKER_NAME = "LS_OBJECT_FIELDS";
    private final Object object;

    public ObjectFieldsAppendingMarker(Object object) {
        super(MARKER_NAME);
        this.object = object;
    }

    @Override
    public void writeTo(JsonGenerator generator, ObjectMapper mapper) throws IOException {
        if (this.object != null) {
            JsonNode jsonNode = mapper.convertValue(this.object, JsonNode.class);
            Iterator<Map.Entry<String, JsonNode>> fields = jsonNode.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field = fields.next();
                generator.writeFieldName(field.getKey());
                generator.writeTree(field.getValue());
            }
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectFieldsAppendingMarker)) {
            return false;
        }
        ObjectFieldsAppendingMarker other = (ObjectFieldsAppendingMarker)((Object)obj);
        return ObjectUtils.equals(this.object, other.object);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }
}

