/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.IOException;
import java.nio.charset.Charset;
import net.logstash.logback.encoder.LogstashEncoder;

public class LogstashTcpEncoder
extends LogstashEncoder {
    private String encoding = "UTF-8";
    private String newLine = System.getProperty("line.separator");

    @Override
    public void doEncode(ILoggingEvent event) throws IOException {
        String log = this.getFormatter().writeValueAsString(event, this.context);
        this.outputStream.write(log.getBytes(this.encoding));
        if (this.newLine != null) {
            this.outputStream.write(this.newLine.getBytes(Charset.forName(this.encoding)));
        }
        if (this.isImmediateFlush()) {
            this.outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.newLine != null) {
            this.outputStream.write(this.newLine.getBytes(Charset.forName(this.encoding)));
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine == null || newLine.isEmpty() ? null : (newLine.equalsIgnoreCase("SYSTEM") ? System.getProperty("line.separator") : (newLine.equalsIgnoreCase("UNIX") ? "\n" : (newLine.equalsIgnoreCase("WINDOWS") ? "\r\n" : newLine)));
    }

    public String getNewLine() {
        return this.newLine;
    }
}

