/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import net.logstash.logback.appender.AsyncDisruptorAppender;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.LifecycleAware;

public abstract class AbstractLogstashTcpSocketAppender<Event extends DeferredProcessingAware>
extends AsyncDisruptorAppender<Event> {
    public static final int DEFAULT_PORT = 4560;
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 8192;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 8192;
    private String remoteHost;
    private int port = 4560;
    private InetAddress remoteAddress;
    private Duration reconnectionDelay = new Duration(30000L);
    private int acceptConnectionTimeout = 5000;
    private String peerId;
    private Encoder<Event> encoder;
    private int writeBufferSize = 8192;
    private SocketFactory socketFactory = SocketFactory.getDefault();

    public AbstractLogstashTcpSocketAppender() {
        this.setEventHandler(new TcpSendingEventHandler());
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.encoder == null) {
            ++errorCount;
            this.addError("No encoder was configured for appender " + this.name + ".");
        }
        if (this.port <= 0) {
            ++errorCount;
            this.addError("No port was configured for appender " + this.name + ".");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.addError("No remote host was configured for appender " + this.name + ".");
        }
        if (errorCount == 0) {
            try {
                this.remoteAddress = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException ex) {
                this.addError("unknown host: " + this.remoteHost);
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            if (this.getThreadNamePrefix() == "logback-async-disruptor-appender-") {
                this.setThreadNamePrefix("logback-async-disruptor-appender-" + this.remoteHost + ":" + this.port + "-");
            }
            this.encoder.setContext(this.getContext());
            if (!this.encoder.isStarted()) {
                this.encoder.start();
            }
            this.peerId = "Log destination " + this.remoteHost + ":" + this.port + ": ";
            super.start();
        }
    }

    public Encoder<Event> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<Event> encoder) {
        this.encoder = encoder;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(Duration delay) {
        if (delay == null || delay.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("reconnectionDelay must be > 0");
        }
        this.reconnectionDelay = delay;
    }

    public Duration getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        this.acceptConnectionTimeout = acceptConnectionTimeout;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public int getQueueSize() {
        return this.getRingBufferSize();
    }

    public void setQueueSize(int queueSize) {
        this.setRingBufferSize(queueSize);
    }

    private class TcpSendingEventHandler
    implements EventHandler<AsyncDisruptorAppender.LogEvent<Event>>,
    LifecycleAware {
        private static final int MAX_REPEAT_CONNECTION_ERROR_LOG = 5;
        private static final int MAX_REPEAT_WRITE_ATTEMPTS = 5;
        private volatile boolean started;
        private volatile Socket socket;
        private volatile OutputStream outputStream;

        private TcpSendingEventHandler() {
        }

        @Override
        public void onEvent(AsyncDisruptorAppender.LogEvent<Event> logEvent, long sequence, boolean endOfBatch) throws Exception {
            for (int i = 0; i < 5; ++i) {
                if (!this.started) {
                    return;
                }
                try {
                    AbstractLogstashTcpSocketAppender.this.encoder.doEncode(logEvent.event);
                    if (!endOfBatch) break;
                    this.outputStream.flush();
                    break;
                }
                catch (SocketException e) {
                    AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "unable to send event: " + e.getMessage(), e);
                    this.reopenSocket();
                    continue;
                }
                catch (IOException e) {
                    AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "unable to send event: " + e.getMessage(), e);
                }
            }
        }

        @Override
        public void onStart() {
            this.started = true;
            this.openSocket();
        }

        @Override
        public void onShutdown() {
            this.started = false;
            this.closeEncoder();
            this.closeSocket();
        }

        private synchronized void reopenSocket() {
            this.closeSocket();
            this.openSocket();
        }

        private synchronized void openSocket() {
            try {
                int errorCount = 0;
                while (this.socket == null && this.started && !Thread.currentThread().isInterrupted()) {
                    long startTime = System.currentTimeMillis();
                    try {
                        this.socket = AbstractLogstashTcpSocketAppender.this.socketFactory.createSocket();
                        this.socket.connect(new InetSocketAddress(AbstractLogstashTcpSocketAppender.this.remoteAddress, AbstractLogstashTcpSocketAppender.this.port), AbstractLogstashTcpSocketAppender.this.acceptConnectionTimeout);
                        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream(), AbstractLogstashTcpSocketAppender.this.writeBufferSize);
                        AbstractLogstashTcpSocketAppender.this.encoder.init(this.outputStream);
                        AbstractLogstashTcpSocketAppender.this.addInfo(AbstractLogstashTcpSocketAppender.this.peerId + "connection established.");
                    }
                    catch (IOException e) {
                        this.closeSocket();
                        long sleepTime = AbstractLogstashTcpSocketAppender.this.reconnectionDelay.getMilliseconds() - (System.currentTimeMillis() - startTime);
                        if (errorCount++ < 5) {
                            AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "connection failed. Waiting " + sleepTime + "ms before attempting reconnection.", e);
                        }
                        if (sleepTime <= 0L) continue;
                        Thread.sleep(sleepTime);
                    }
                }
            }
            catch (InterruptedException e) {
                AbstractLogstashTcpSocketAppender.this.addWarn(AbstractLogstashTcpSocketAppender.this.peerId + "connection interrupted");
            }
        }

        private synchronized void closeSocket() {
            CloseUtil.closeQuietly((Closeable)this.outputStream);
            this.outputStream = null;
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
        }

        private void closeEncoder() {
            try {
                AbstractLogstashTcpSocketAppender.this.encoder.close();
            }
            catch (IOException ioe) {
                AbstractLogstashTcpSocketAppender.this.addStatus((Status)new ErrorStatus("Failed to close encoder for appender named [" + AbstractLogstashTcpSocketAppender.this.name + "].", (Object)this, (Throwable)ioe));
            }
            AbstractLogstashTcpSocketAppender.this.encoder.stop();
        }
    }
}

