/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Map;

public class JsonWritingUtils {
    public static void writeMapEntries(JsonGenerator generator, Map<?, ?> map) throws IOException, JsonMappingException {
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                generator.writeFieldName(entry.getKey().toString());
                generator.writeObject(entry.getValue());
            }
        }
    }

    public static void writeMapStringFields(JsonGenerator generator, String fieldName, Map<String, String> map) throws IOException, JsonMappingException {
        if (JsonWritingUtils.shouldWriteField(fieldName) && map != null && !map.isEmpty()) {
            generator.writeObjectFieldStart(fieldName);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                JsonWritingUtils.writeStringField(generator, entry.getKey(), entry.getValue());
            }
            generator.writeEndObject();
        }
    }

    public static void writeStringField(JsonGenerator generator, String fieldName, String fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName) && fieldValue != null) {
            generator.writeStringField(fieldName, fieldValue);
        }
    }

    public static void writeNumberField(JsonGenerator generator, String fieldName, int fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName)) {
            generator.writeNumberField(fieldName, fieldValue);
        }
    }

    public static void writeNumberField(JsonGenerator generator, String fieldName, long fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName)) {
            generator.writeNumberField(fieldName, fieldValue);
        }
    }

    public static boolean shouldWriteField(String fieldName) {
        return fieldName != null && !fieldName.equals("[ignore]");
    }
}

