/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.joran.spi.DefaultClass;
import java.util.Objects;
import net.logstash.logback.abbreviator.DefaultTargetLengthAbbreviator;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import net.logstash.logback.util.LogbackUtils;
import tools.jackson.core.JsonGenerator;

public class LoggerNameJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_LOGGER_NAME = "logger_name";
    private Abbreviator abbreviator = new DefaultTargetLengthAbbreviator();

    public LoggerNameJsonProvider() {
        this.setFieldName(FIELD_LOGGER_NAME);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Generator is not started");
        }
        JsonWritingUtils.writeStringField(generator, this.getFieldName(), this.abbreviator.abbreviate(event.getLoggerName()));
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getLogger());
    }

    public int getShortenedLoggerNameLength() {
        if (this.abbreviator instanceof DefaultTargetLengthAbbreviator) {
            return ((DefaultTargetLengthAbbreviator)this.abbreviator).getTargetLength();
        }
        throw new IllegalStateException("Cannot invoke getShortenedLoggerNameLength on non default abbreviator");
    }

    public void setShortenedLoggerNameLength(int length) {
        if (!(this.abbreviator instanceof DefaultTargetLengthAbbreviator)) {
            throw new IllegalStateException("Cannot set shortenedLoggerNameLength on non default Abbreviator");
        }
        ((DefaultTargetLengthAbbreviator)this.abbreviator).setTargetLength(length);
    }

    @Override
    public void start() {
        LogbackUtils.start(this.getContext(), this.abbreviator);
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        LogbackUtils.stop(this.abbreviator);
    }

    @DefaultClass(value=DefaultTargetLengthAbbreviator.class)
    public void setAbbreviator(Abbreviator abbreviator) {
        this.abbreviator = Objects.requireNonNull(abbreviator);
    }

    public Abbreviator getAbbreviator() {
        return this.abbreviator;
    }
}

