/*
 * Decompiled with CFR 0.152.
 */
package net.lopht.maven.plugins.upload;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.RepositorySystem;

public abstract class AbstractUploadMojo
extends AbstractMojo {
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ArtifactRepositoryLayout repositoryLayout;
    @Parameter(property="session")
    protected MavenSession session;
    @Parameter(property="upload.serverId")
    protected String serverId;
    @Parameter(property="upload.repositoryUrl")
    protected String repositoryUrl;
    @Parameter(property="upload.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="upload.preemptiveAuth", defaultValue="false")
    protected boolean preemptiveAuth;
    @Parameter
    protected Map<String, String> headers;
    @Parameter(property="upload.post", defaultValue="false")
    protected boolean usePOST;

    protected CloseableHttpClient getHttpClient(ArtifactRepository repository) throws MojoExecutionException {
        Proxy proxy;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicCredentialsProvider credsProvider = null;
        Authentication authentication = repository.getAuthentication();
        if (authentication != null) {
            this.getLog().debug((CharSequence)("Found credentials: username=" + authentication.getUsername() + " password=" + authentication.getPassword()));
            credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(authentication.getUsername(), authentication.getPassword()));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        if ((proxy = repository.getProxy()) != null) {
            if (proxy.getProtocol() == null || proxy.getProtocol().equalsIgnoreCase("HTTP")) {
                this.getLog().debug((CharSequence)("Found Proxy configuration: " + proxy.getHost() + ":" + proxy.getPort()));
                HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
                clientBuilder.setProxy(proxyHost);
                if (proxy.getUserName() != null) {
                    this.getLog().debug((CharSequence)("Found proxy credentials: username=" + proxy.getUserName()));
                    if (credsProvider == null) {
                        credsProvider = new BasicCredentialsProvider();
                        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                    }
                    credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(proxy.getUserName(), proxy.getPassword()));
                    clientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
                }
            } else {
                throw new MojoExecutionException("Proxy protocol " + proxy.getProtocol() + " is not supported yet");
            }
        }
        return clientBuilder.build();
    }

    protected ArtifactRepository getArtifactRepository() {
        ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy();
        ArtifactRepository repository = this.repositorySystem.createArtifactRepository(this.serverId, this.repositoryUrl, this.repositoryLayout, policy, policy);
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        repositories.add(repository);
        this.repositorySystem.injectProxy(repositories, this.session.getRequest().getProxies());
        this.repositorySystem.injectAuthentication(repositories, this.session.getRequest().getServers());
        repository = (ArtifactRepository)repositories.get(0);
        return repository;
    }

    protected void uploadFile(CloseableHttpClient client, File file, String targetUrl) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Uploading " + file.getAbsolutePath() + " to " + targetUrl));
        Object request = this.usePOST ? new HttpPost(targetUrl) : new HttpPut(targetUrl);
        CloseableHttpResponse response = null;
        try {
            ContentType contentType = null;
            if (file.getName().endsWith(".xml")) {
                contentType = ContentType.APPLICATION_XML;
            }
            request.setEntity((HttpEntity)new FileEntity(file, contentType));
            if (null != this.headers) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (this.preemptiveAuth) {
                URL aURL = new URL(targetUrl);
                HttpHost target = new HttpHost(aURL.getHost(), aURL.getPort(), aURL.getProtocol());
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(target, (AuthScheme)basicAuth);
                HttpClientContext localContext = HttpClientContext.create();
                localContext.setAuthCache((AuthCache)authCache);
                response = client.execute((HttpUriRequest)request, (HttpContext)localContext);
            } else {
                response = client.execute((HttpUriRequest)request);
            }
            int status = response.getStatusLine().getStatusCode();
            if (status < 200 || status > 299) {
                String message = "Could not upload file: " + response.getStatusLine().toString();
                this.getLog().error((CharSequence)message);
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responseBody != null) {
                    this.getLog().info((CharSequence)responseBody);
                }
                throw new MojoExecutionException(message);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not upload file: ", (Exception)e);
        }
        finally {
            request.releaseConnection();
        }
    }
}

