/*
 * Decompiled with CFR 0.152.
 */
package net.lopht.maven.plugins.upload;

import java.io.File;
import net.lopht.maven.plugins.upload.AbstractUploadMojo;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upload-file", defaultPhase=LifecyclePhase.DEPLOY)
public class FileUploadMojo
extends AbstractUploadMojo {
    @Parameter(property="upload.file")
    private File file;
    @Parameter(property="upload.repositoryPath")
    private String repositoryPath;
    @Parameter(property="upload.ignoreMissing", defaultValue="false")
    private boolean ignoreMissingFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution per configuration");
            return;
        }
        if (this.ignoreMissingFile && !this.file.exists()) {
            this.getLog().info((CharSequence)("File does not exist, ignoring " + this.file.getAbsolutePath()));
            return;
        }
        ArtifactRepository repository = this.getArtifactRepository();
        CloseableHttpClient client = this.getHttpClient(repository);
        String url = this.getTargetUrl(repository);
        this.getLog().info((CharSequence)("Upload target url: " + url));
        this.uploadFile(client, this.file, url);
    }

    private String getTargetUrl(ArtifactRepository repository) {
        StringBuilder sb = new StringBuilder(repository.getUrl());
        if (!repository.getUrl().endsWith("/") && !this.repositoryPath.startsWith("/")) {
            sb.append("/");
        }
        sb.append(this.repositoryPath);
        return sb.toString();
    }
}

