/*
 * Decompiled with CFR 0.152.
 */
package net.lopht.maven.plugins.upload;

import java.io.File;
import net.lopht.maven.plugins.upload.AbstractUploadMojo;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="upload-files", defaultPhase=LifecyclePhase.DEPLOY)
public class FilesUploadMojo
extends AbstractUploadMojo {
    @Parameter(property="upload.basedir", defaultValue="${project.basedir}")
    private File basedir;
    @Parameter(property="upload.includes")
    private String[] includes;
    @Parameter(property="upload.excludes")
    private String[] excludes;
    @Parameter(property="upload.repositoryBasePath")
    private String repositoryBasepath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution per configuration");
            return;
        }
        ArtifactRepository repository = this.getArtifactRepository();
        CloseableHttpClient client = this.getHttpClient(repository);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.basedir);
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        String baseUrl = repository.getUrl();
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        if (this.repositoryBasepath != null) {
            baseUrl = baseUrl + this.repositoryBasepath;
        }
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        for (String relPath : scanner.getIncludedFiles()) {
            String path = relPath.replace('\\', '/');
            this.uploadFile(client, new File(this.basedir, path), baseUrl + path);
        }
    }
}

