/*
 * Decompiled with CFR 0.152.
 */
package net.lshift.diffa.snowflake;

import com.netflix.curator.RetryPolicy;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.CuratorFrameworkFactory;
import com.netflix.curator.framework.recipes.locks.InterProcessMutex;
import com.netflix.curator.retry.RetryUntilElapsed;
import java.util.concurrent.TimeUnit;
import net.lshift.diffa.snowflake.IdentityGenerator;

public class MachineIdAssigner {
    private static final String DEFAULT_CLUSTER = "localhost:2181";
    private static final int connectionTimeoutMs = 2000;
    private static final int maxElapsedTimeMs = 3000;
    private static final int sleepMsBetweenRetries = 100;
    private static final RetryPolicy retryPolicy = new RetryUntilElapsed(3000, 100);
    private static final long acquireTimeout = 50L;
    private static final TimeUnit acquireTimeoutTimeUnit = TimeUnit.MILLISECONDS;
    private static final int COLLISION_MAX_RETRIES = 30;
    private static final int DEFAULT_SESSION_TIMEOUT = 60000;
    private static final int ERR_IDENTIFIER_IN_USE = -1;
    private static final int ERR_ZK_FAILURE = -2;
    CuratorFramework curator;

    public static MachineIdAssigner localDefault() throws Exception {
        return MachineIdAssigner.getInstance(DEFAULT_CLUSTER);
    }

    public static MachineIdAssigner getInstance(String cluster) throws Exception {
        return MachineIdAssigner.withSessionTimeout(cluster, 60000);
    }

    public static MachineIdAssigner withSessionTimeout(String cluster, int timeoutMs) throws Exception {
        return new MachineIdAssigner(cluster, timeoutMs);
    }

    MachineIdAssigner(String zkCluster, int sessionTimeoutMs) throws Exception {
        this.curator = CuratorFrameworkFactory.newClient((String)zkCluster, (int)sessionTimeoutMs, (int)2000, (RetryPolicy)retryPolicy);
        this.curator.start();
    }

    public String pathFromId(int id) {
        return String.format("/machine_id/%d", id);
    }

    public int assign(IdentityGenerator generator) {
        for (int retryCount = 0; retryCount < 30; ++retryCount) {
            try {
                int id = generator.generate();
                if (!this.tryAssign(this.pathFromId(id))) continue;
                return id;
            }
            catch (Exception e) {
                return -2;
            }
        }
        return -1;
    }

    private boolean tryAssign(String path) throws Exception {
        InterProcessMutex lock = new InterProcessMutex(this.curator, path);
        return lock.acquire(50L, acquireTimeoutTimeUnit);
    }

    @Deprecated
    public void releaseAll() {
        this.curator.close();
    }
}

