/*
 * Decompiled with CFR 0.152.
 */
package net.lshift.diffa.snowflake;

import net.lshift.diffa.snowflake.IdProvider;
import net.lshift.diffa.snowflake.InvalidSystemClockException;
import net.lshift.diffa.snowflake.SequenceExhaustedException;
import net.lshift.diffa.snowflake.SystemTimeFunction;
import net.lshift.diffa.snowflake.TimeFunction;

public class SnowflakeIdProvider
implements IdProvider {
    public static final int machineBits = 10;
    public static final int sequenceBits = 12;
    public static final short machineIdUpperBound = (short)(Math.round(Math.pow(2.0, 10.0)) - 1L);
    public static final short sequenceUpperBound = (short)(Math.round(Math.pow(2.0, 12.0)) - 1L);
    public static final int timestampLShift = 22;
    public static final int machineLShift = 12;
    public static final int sequenceLShift = 0;
    private int machineId;
    private long pauseMs = 0L;
    private TimeFunction timeFn = SystemTimeFunction.getInstance();
    private short sequenceNum = 0;
    private long lastTimestamp = -1L;
    private final Object mutex = new Object();

    public SnowflakeIdProvider(int machineId) {
        if (machineId < 0 || machineId > machineIdUpperBound) {
            throw new IllegalArgumentException("machineId must be in the (inclusive) range [0, 1023]");
        }
        this.machineId = machineId;
    }

    public void setTimeFn(TimeFunction timeFn) {
        this.timeFn = timeFn;
    }

    public void setPauseMs(int pause) {
        this.pauseMs = pause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getId() throws InvalidSystemClockException, SequenceExhaustedException {
        long seq;
        long now = this.timeFn.now();
        Object object = this.mutex;
        synchronized (object) {
            this.maybePause();
            if (now < this.lastTimestamp) {
                throw new InvalidSystemClockException();
            }
            if (now > this.lastTimestamp) {
                this.sequenceNum = 0;
            } else if (this.sequenceNum < sequenceUpperBound) {
                this.sequenceNum = (short)(this.sequenceNum + 1);
            } else {
                throw new SequenceExhaustedException(this.sequenceNum);
            }
            seq = this.sequenceNum;
            this.lastTimestamp = now;
        }
        return now << 22 | (long)(this.machineId << 12) | seq << 0;
    }

    private void maybePause() {
        if (this.pauseMs > 0L) {
            try {
                Thread.sleep(this.pauseMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

