/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-module", threadSafe=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateModuleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter
    private String moduleName;
    @Parameter
    private String moduleShortName;
    @Parameter(defaultValue="${project.basedir}/src/main/module.gwt.xml")
    private File moduleTemplate;
    @Parameter(defaultValue="false")
    private boolean skipModule;
    @Parameter(defaultValue="true")
    private boolean generateInheritsFromDependencies = true;
    @Parameter(defaultValue="${project.dependencyArtifacts}", required=true, readonly=true)
    private Set<Artifact> dependencyArtifacts;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    private final ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("compile+runtime");

    public void execute() throws MojoExecutionException, MojoFailureException {
        Xpp3Dom template;
        boolean uptodate;
        if (this.skipModule) {
            return;
        }
        if (StringUtils.isBlank((String)this.moduleName)) {
            throw new MojoExecutionException("Missing moduleName");
        }
        File outputFile = new File(this.outputDirectory, this.moduleName.replace('.', '/') + ".gwt.xml");
        if (this.moduleTemplate != null && this.moduleTemplate.isFile()) {
            uptodate = this.buildContext.isUptodate(outputFile, this.moduleTemplate);
            try {
                template = Xpp3DomBuilder.build((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.moduleTemplate), StandardCharsets.UTF_8)));
            }
            catch (IOException | XmlPullParserException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else {
            uptodate = true;
            template = new Xpp3Dom("module");
        }
        if (uptodate) {
            uptodate = this.buildContext.isUptodate(outputFile, this.project.getFile());
        }
        if (uptodate) {
            // empty if block
        }
        outputFile.getParentFile().mkdirs();
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)writer);
            xmlWriter.startElement("module");
            String oldRenameTo = template.getAttribute("rename-to");
            if (!StringUtils.isBlank((String)this.moduleShortName)) {
                if (oldRenameTo != null) {
                    this.getLog().info((CharSequence)("Overriding module short name " + oldRenameTo + " with " + this.moduleShortName));
                }
                xmlWriter.addAttribute("rename-to", this.moduleShortName);
            } else if (oldRenameTo != null) {
                xmlWriter.addAttribute("rename-to", oldRenameTo);
            }
            for (String attrName : template.getAttributeNames()) {
                if ("rename-to".equals(attrName)) continue;
                xmlWriter.addAttribute(attrName, template.getAttribute(attrName));
            }
            boolean hasInherits = this.generateInheritsFromDependencies((XMLWriter)xmlWriter);
            boolean hasSource = false;
            for (Xpp3Dom child : template.getChildren()) {
                if ("inherits".equals(child.getName())) {
                    hasInherits = true;
                } else if ("source".equals(child.getName()) || "super-source".equals(child.getName())) {
                    hasSource = true;
                }
                Xpp3DomWriter.write((XMLWriter)xmlWriter, (Xpp3Dom)child);
            }
            if (!hasInherits) {
                xmlWriter.startElement("inherits");
                xmlWriter.addAttribute("name", "com.google.gwt.core.Core");
                xmlWriter.endElement();
            }
            if (!hasSource) {
                xmlWriter.startElement("source");
                xmlWriter.addAttribute("path", "client");
                xmlWriter.endElement();
                xmlWriter.startElement("source");
                xmlWriter.addAttribute("path", "shared");
                xmlWriter.endElement();
                xmlWriter.startElement("super-source");
                xmlWriter.addAttribute("path", "super");
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        try {
            if (outputFile.isFile() && ((Object)writer).toString().equals(FileUtils.fileRead((File)outputFile, (String)"UTF-8"))) {
                this.getLog().info((CharSequence)(outputFile.getAbsolutePath() + " up to date - skipping"));
                return;
            }
            FileUtils.fileWrite((File)outputFile, (String)"UTF-8", (String)((Object)writer).toString());
            this.buildContext.refresh(outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private boolean generateInheritsFromDependencies(XMLWriter xmlWriter) throws IOException, MojoExecutionException {
        ClassRealm realm;
        if (!this.generateInheritsFromDependencies) {
            return false;
        }
        ClassWorld world = new ClassWorld();
        try {
            realm = world.newRealm("gwt", null);
            for (Artifact artifact : this.dependencyArtifacts) {
                if (!this.artifactFilter.include(artifact) || !artifact.getArtifactHandler().isAddedToClasspath()) continue;
                realm.addURL(artifact.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException | DuplicateRealmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        boolean hasInherits = false;
        Enumeration resources = realm.getResources("META-INF/gwt/mainModule");
        while (resources.hasMoreElements()) {
            URL resource = (URL)resources.nextElement();
            String moduleName = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    if (!(line = this.removeCommentAndTrim(line)).isEmpty()) {
                        if (moduleName != null) {
                            this.getLog().warn((CharSequence)("Configuration file contains more than one module name, picking first: " + resource));
                            break;
                        }
                        moduleName = line;
                    }
                    line = reader.readLine();
                }
            }
            if (moduleName == null) continue;
            hasInherits = true;
            xmlWriter.startElement("inherits");
            xmlWriter.addAttribute("name", moduleName);
            xmlWriter.endElement();
        }
        return hasInherits;
    }

    private String removeCommentAndTrim(String line) {
        int commentPos = line.indexOf(35);
        if (commentPos >= 0) {
            line = line.substring(0, commentPos);
        }
        return line.trim();
    }
}

