/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.jspecify.annotations.Nullable;

class CommandLine {
    private final Log log;
    private final MavenProject project;
    private final MavenSession session;
    private final ToolchainManager toolchainManager;
    private final Map<String, String> toolchainRequirements;
    private final String jvm;

    CommandLine(Log log, MavenProject project, MavenSession session, ToolchainManager toolchainManager, Map<String, String> toolchainRequirements, String jvm) {
        this.log = log;
        this.project = project;
        this.session = session;
        this.toolchainManager = toolchainManager;
        this.toolchainRequirements = toolchainRequirements;
        this.jvm = jvm;
    }

    void execute(Iterable<String> classpath, List<String> arguments) throws MojoExecutionException {
        int result;
        String cp = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
        String[] args = arguments.toArray(new String[arguments.size()]);
        org.apache.commons.exec.CommandLine commandline = new org.apache.commons.exec.CommandLine(this.getExecutable());
        commandline.addArguments(args);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setWorkingDirectory(new File(this.project.getBuild().getDirectory()));
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new LogOutputStream(){

            protected void processLine(String line, int logLevel) {
                CommandLine.this.log.info((CharSequence)line);
            }
        }, (OutputStream)new LogOutputStream(){

            protected void processLine(String line, int logLevel) {
                CommandLine.this.log.warn((CharSequence)line);
            }
        }));
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>(System.getenv());
        env.put("CLASSPATH", cp);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Classpath: " + cp));
            this.log.debug((CharSequence)("Arguments: " + String.join((CharSequence)" ", commandline.getArguments())));
        }
        try {
            result = executor.execute(commandline, env);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (result != 0) {
            throw new MojoExecutionException("GWT exited with status " + result);
        }
    }

    private String getExecutable() {
        String executable;
        if (StringUtils.isNotBlank((String)this.jvm)) {
            return this.jvm;
        }
        Toolchain tc = this.getToolchain();
        if (tc != null && StringUtils.isNotBlank((String)(executable = tc.findTool("java")))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Toolchain: " + tc));
            }
            return executable;
        }
        return Paths.get(System.getProperty("java.home"), "bin", "java").toString();
    }

    private @Nullable Toolchain getToolchain() {
        List tcs;
        Toolchain tc = null;
        if (this.toolchainRequirements != null && !this.toolchainRequirements.isEmpty() && (tcs = this.toolchainManager.getToolchains(this.session, "jdk", this.toolchainRequirements)) != null && !tcs.isEmpty()) {
            tc = (Toolchain)tcs.get(0);
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }
}

