/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.ltgt.gwt.maven.AbstractDevModeMojo;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="devmode", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true, aggregator=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class DevModeMojo
extends AbstractDevModeMojo {
    @Parameter(defaultValue="${project.build.directory}/gwt/devmode/work", required=true)
    private File devmodeWorkDir;
    @Parameter(defaultValue="${project.build.directory}/gwt/devmode/war", required=true)
    private File warDir;
    @Parameter
    private List<String> startupUrls;
    @Parameter
    private List<String> devmodeArgs;

    @Override
    protected String getMainClass() {
        return "com.google.gwt.dev.DevMode";
    }

    @Override
    protected File getWorkDir() {
        return this.devmodeWorkDir;
    }

    @Override
    protected Collection<String> getSpecificArguments(Set<String> sources) {
        ArrayList<String> args = new ArrayList<String>(2 + (this.startupUrls == null ? 0 : this.startupUrls.size() * 2) + (this.devmodeArgs == null ? 0 : this.devmodeArgs.size()));
        args.add("-war");
        args.add(this.warDir.getAbsolutePath());
        if (this.startupUrls != null) {
            for (String startupUrl : this.startupUrls) {
                args.add("-startupUrl");
                args.add(startupUrl);
            }
        }
        if (this.devmodeArgs != null) {
            args.addAll(this.devmodeArgs);
        }
        return args;
    }

    @Override
    protected boolean prependSourcesToClasspath() {
        return true;
    }

    @Override
    protected void forceMkdirs() throws IOException {
        FileUtils.forceMkdir((File)this.warDir);
    }
}

