/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-module-metadata", threadSafe=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateModuleMetadataMojo
extends AbstractMojo {
    @Parameter
    private String moduleName;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/gwt", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean skipModuleMetadata;
    @Inject
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipModuleMetadata) {
            return;
        }
        if (StringUtils.isBlank((String)this.moduleName)) {
            throw new MojoExecutionException("Missing moduleName");
        }
        File outputFile = new File(this.outputDirectory, "mainModule");
        if (outputFile.isFile()) {
            try {
                String content = FileUtils.fileRead((File)outputFile, (String)"UTF-8");
                if (content.trim().equals(this.moduleName)) {
                    this.getLog().info((CharSequence)(outputFile.getAbsolutePath() + " up to date - skipping."));
                    return;
                }
            }
            catch (IOException content) {
                // empty catch block
            }
        }
        this.outputDirectory.mkdirs();
        try {
            FileUtils.fileWrite((File)outputFile, (String)"UTF-8", (String)this.moduleName);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.buildContext.refresh(outputFile);
    }
}

