/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.jspecify.annotations.Nullable;

public interface GwtOptions {
    public @Nullable String getLogLevel();

    public @Nullable String getStyle();

    public @Nullable Integer getOptimize();

    public File getWarDir();

    public File getWorkDir();

    public File getDeployDir();

    public @Nullable File getExtraDir();

    public boolean isDraftCompile();

    public @Nullable String getLocalWorkers();

    public @Nullable String getSourceLevel();

    public static class CommandlineBuilder {
        public static List<String> buildArgs(Log log, GwtOptions options) {
            ArrayList<String> args = new ArrayList<String>();
            if (options.getLogLevel() != null) {
                args.add("-logLevel");
                args.add(options.getLogLevel());
            }
            args.add("-war");
            args.add(options.getWarDir().getAbsolutePath());
            args.add("-workDir");
            args.add(options.getWorkDir().getAbsolutePath());
            args.add("-deploy");
            args.add(options.getDeployDir().getAbsolutePath());
            if (options.getExtraDir() != null) {
                args.add("-extra");
                args.add(options.getExtraDir().getAbsolutePath());
            }
            if (options.getStyle() != null) {
                args.add("-style");
                args.add(options.getStyle());
            }
            if (options.getLocalWorkers() != null) {
                args.add("-localWorkers");
                args.add(CommandlineBuilder.getLocalWorkers(options.getLocalWorkers()));
            }
            if (options.isDraftCompile()) {
                args.add("-draftCompile");
            } else if (options.getOptimize() != null) {
                args.add("-optimize");
                args.add(String.valueOf(options.getOptimize()));
            }
            if (options.getSourceLevel() != null) {
                args.add("-sourceLevel");
                args.add(options.getSourceLevel());
            }
            return args;
        }

        private static String getLocalWorkers(String localWorkers) {
            int workers = localWorkers.contains("C") ? (int)(Float.valueOf(localWorkers.replace("C", "")).floatValue() * (float)Runtime.getRuntime().availableProcessors()) : Integer.valueOf(localWorkers);
            return String.valueOf(workers);
        }
    }
}

