/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.rest.service;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.luckperms.rest.model.CreateUserRequest;
import net.luckperms.rest.model.DemotionResult;
import net.luckperms.rest.model.Metadata;
import net.luckperms.rest.model.Node;
import net.luckperms.rest.model.NodeType;
import net.luckperms.rest.model.PermissionCheckRequest;
import net.luckperms.rest.model.PermissionCheckResult;
import net.luckperms.rest.model.PlayerSaveResult;
import net.luckperms.rest.model.PromotionResult;
import net.luckperms.rest.model.TemporaryNodeMergeStrategy;
import net.luckperms.rest.model.TrackRequest;
import net.luckperms.rest.model.UpdateUserRequest;
import net.luckperms.rest.model.User;
import net.luckperms.rest.model.UserLookupResult;
import net.luckperms.rest.model.UserSearchResult;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface UserService {
    @GET(value="/user")
    public Call<Set<UUID>> list();

    @POST(value="/user")
    public Call<PlayerSaveResult> create(@Body CreateUserRequest var1);

    @GET(value="/user/lookup")
    public Call<UserLookupResult> lookup(@Query(value="username") String var1);

    @GET(value="/user/lookup")
    public Call<UserLookupResult> lookup(@Query(value="uniqueId") UUID var1);

    @GET(value="/user/search")
    public Call<List<UserSearchResult>> searchNodesByKey(@Query(value="key") String var1);

    @GET(value="/user/search")
    public Call<List<UserSearchResult>> searchNodesByKeyStartsWith(@Query(value="keyStartsWith") String var1);

    @GET(value="/user/search")
    public Call<List<UserSearchResult>> searchNodesByMetaKey(@Query(value="metaKey") String var1);

    @GET(value="/user/search")
    public Call<List<UserSearchResult>> searchNodesByType(@Query(value="type") NodeType var1);

    @GET(value="/user/{uniqueId}")
    public Call<User> get(@Path(value="uniqueId") UUID var1);

    @PATCH(value="/user/{uniqueId}")
    public Call<Void> update(@Path(value="uniqueId") UUID var1, @Body UpdateUserRequest var2);

    @DELETE(value="/user/{uniqueId}")
    public Call<Void> delete(@Path(value="uniqueId") UUID var1);

    @DELETE(value="/user/{uniqueId}")
    public Call<Void> delete(@Path(value="uniqueId") UUID var1, @Query(value="playerDataOnly") boolean var2);

    @GET(value="/user/{uniqueId}/nodes")
    public Call<List<Node>> nodes(@Path(value="uniqueId") UUID var1);

    @POST(value="/user/{uniqueId}/nodes")
    public Call<List<Node>> nodesAdd(@Path(value="uniqueId") UUID var1, @Body Node var2);

    @POST(value="/user/{uniqueId}/nodes")
    public Call<List<Node>> nodesAdd(@Path(value="uniqueId") UUID var1, @Body Node var2, @Query(value="temporaryNodeMergeStrategy") TemporaryNodeMergeStrategy var3);

    @PATCH(value="/user/{uniqueId}/nodes")
    public Call<List<Node>> nodesAdd(@Path(value="uniqueId") UUID var1, @Body List<Node> var2);

    @PATCH(value="/user/{uniqueId}/nodes")
    public Call<List<Node>> nodesAdd(@Path(value="uniqueId") UUID var1, @Body List<Node> var2, @Query(value="temporaryNodeMergeStrategy") TemporaryNodeMergeStrategy var3);

    @PUT(value="/user/{uniqueId}/nodes")
    public Call<Void> nodesSet(@Path(value="uniqueId") UUID var1, @Body List<Node> var2);

    @DELETE(value="/user/{uniqueId}/nodes")
    public Call<Void> nodesDelete(@Path(value="uniqueId") UUID var1);

    @HTTP(method="DELETE", path="/user/{uniqueId}/nodes", hasBody=true)
    public Call<Void> nodesDelete(@Path(value="uniqueId") UUID var1, @Body List<Node> var2);

    @GET(value="/user/{uniqueId}/meta")
    public Call<Metadata> metadata(@Path(value="uniqueId") UUID var1);

    @GET(value="/user/{uniqueId}/permission-check")
    public Call<PermissionCheckResult> permissionCheck(@Path(value="uniqueId") UUID var1, @Query(value="permission") String var2);

    @POST(value="/user/{uniqueId}/permission-check")
    public Call<PermissionCheckResult> permissionCheck(@Path(value="uniqueId") UUID var1, @Body PermissionCheckRequest var2);

    @POST(value="/user/{uniqueId}/promote")
    public Call<PromotionResult> promote(@Path(value="uniqueId") UUID var1, @Body TrackRequest var2);

    @POST(value="/user/{uniqueId}/demote")
    public Call<DemotionResult> demote(@Path(value="uniqueId") UUID var1, @Body TrackRequest var2);
}

