/*
 * Decompiled with CFR 0.152.
 */
package chrome.tabs;

import chrome.ChromeAPI;
import chrome.events.EventSource;
import chrome.events.EventSourceImplicits$;
import chrome.permissions.Permission;
import chrome.permissions.Permission$API$;
import chrome.runtime.bindings.Port;
import chrome.tabs.bindings.ActiveInfo;
import chrome.tabs.bindings.AttachInfo;
import chrome.tabs.bindings.CaptureOptions;
import chrome.tabs.bindings.ChangeInfo;
import chrome.tabs.bindings.CodeInjectionOptions;
import chrome.tabs.bindings.ConnectInfo;
import chrome.tabs.bindings.DetachInfo;
import chrome.tabs.bindings.HighlightInfo;
import chrome.tabs.bindings.MessageOptions;
import chrome.tabs.bindings.MoveInfo;
import chrome.tabs.bindings.MoveProperties;
import chrome.tabs.bindings.ReloadProperties;
import chrome.tabs.bindings.RemoveInfo;
import chrome.tabs.bindings.Tab;
import chrome.tabs.bindings.TabCreateProperties;
import chrome.tabs.bindings.TabQuery;
import chrome.tabs.bindings.UpdateProperties;
import chrome.tabs.bindings.ZoomChangeInfo;
import chrome.tabs.bindings.ZoomSettings;
import chrome.utils.ErrorHandling$;
import chrome.windows.bindings.Window;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.scalajs.js.;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.Array$;
import scala.scalajs.js.Function0;
import scala.scalajs.js.Function1;
import scala.scalajs.js.UndefOr;
import scala.scalajs.js.UndefOr$;
import scala.scalajs.js.package$;

public final class Tabs$
implements ChromeAPI {
    public static final Tabs$ MODULE$;
    private final Set<Permission.API> requiredPermissions;
    private final EventSource<Tab> onCreated;
    private final EventSource<Tuple3<Object, ChangeInfo, Tab>> onUpdated;
    private final EventSource<Tuple2<Object, MoveInfo>> onMoved;
    private final EventSource<ActiveInfo> onActivated;
    private final EventSource<HighlightInfo> onHighlighted;
    private final EventSource<Tuple2<Object, DetachInfo>> onDetached;
    private final EventSource<Tuple2<Object, AttachInfo>> onAttached;
    private final EventSource<Tuple2<Object, RemoveInfo>> onRemoved;
    private final EventSource<Tuple2<Object, Object>> onReplaced;
    private final EventSource<ZoomChangeInfo> onZoomChange;

    static {
        new Tabs$();
    }

    @Override
    public Set<Permission.API> requiredPermissions() {
        return this.requiredPermissions;
    }

    public EventSource<Tab> onCreated() {
        return this.onCreated;
    }

    public EventSource<Tuple3<Object, ChangeInfo, Tab>> onUpdated() {
        return this.onUpdated;
    }

    public EventSource<Tuple2<Object, MoveInfo>> onMoved() {
        return this.onMoved;
    }

    public EventSource<ActiveInfo> onActivated() {
        return this.onActivated;
    }

    public EventSource<HighlightInfo> onHighlighted() {
        return this.onHighlighted;
    }

    public EventSource<Tuple2<Object, DetachInfo>> onDetached() {
        return this.onDetached;
    }

    public EventSource<Tuple2<Object, AttachInfo>> onAttached() {
        return this.onAttached;
    }

    public EventSource<Tuple2<Object, RemoveInfo>> onRemoved() {
        return this.onRemoved;
    }

    public EventSource<Tuple2<Object, Object>> onReplaced() {
        return this.onReplaced;
    }

    public EventSource<ZoomChangeInfo> onZoomChange() {
        return this.onZoomChange;
    }

    public Future<Tab> get(int tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.get(tabId, Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$1;

            public final Promise<Tab> apply(Tab tab) {
                return this.promise$1.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, tab){
                    public static final long serialVersionUID = 0L;
                    private final Tab tab$1;

                    public final Tab apply() {
                        return this.tab$1;
                    }
                    {
                        this.tab$1 = tab$1;
                    }
                }));
            }
            {
                this.promise$1 = promise$1;
            }
        }));
        return promise.future();
    }

    public Future<Tab> getCurrent() {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getCurrent(Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$2;

            public final Promise<Tab> apply(Tab tab) {
                return this.promise$2.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, tab){
                    public static final long serialVersionUID = 0L;
                    private final Tab tab$2;

                    public final Tab apply() {
                        return this.tab$2;
                    }
                    {
                        this.tab$2 = tab$2;
                    }
                }));
            }
            {
                this.promise$2 = promise$2;
            }
        }));
        return promise.future();
    }

    public Port connect(int tabId, UndefOr<ConnectInfo> connectInfo) {
        return chrome.tabs.bindings.Tabs$.MODULE$.connect(tabId, connectInfo);
    }

    public UndefOr<ConnectInfo> connect$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<Any> sendRequest(int tabId, Any request2) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.sendRequest(tabId, request2, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$3;

            public final Promise<Any> apply(Any response2) {
                return this.promise$3.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, response2){
                    public static final long serialVersionUID = 0L;
                    private final Any response$1;

                    public final Any apply() {
                        return this.response$1;
                    }
                    {
                        this.response$1 = response$1;
                    }
                }));
            }
            {
                this.promise$3 = promise$3;
            }
        })));
        return promise.future();
    }

    public Future<Any> sendMessage(int tabId, Any message, UndefOr<MessageOptions> options) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.sendMessage(tabId, message, options, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$4;

            public final Promise<Any> apply(Any response2) {
                return this.promise$4.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, response2){
                    public static final long serialVersionUID = 0L;
                    private final Any response$2;

                    public final Any apply() {
                        return this.response$2;
                    }
                    {
                        this.response$2 = response$2;
                    }
                }));
            }
            {
                this.promise$4 = promise$4;
            }
        })));
        return promise.future();
    }

    public UndefOr<MessageOptions> sendMessage$default$3() {
        return package$.MODULE$.undefined();
    }

    public Future<Tab> create(TabCreateProperties createProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.create(createProperties, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$5;

            public final Promise<Tab> apply(Tab tab) {
                return this.promise$5.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, tab){
                    public static final long serialVersionUID = 0L;
                    private final Tab tab$3;

                    public final Tab apply() {
                        return this.tab$3;
                    }
                    {
                        this.tab$3 = tab$3;
                    }
                }));
            }
            {
                this.promise$5 = promise$5;
            }
        })));
        return promise.future();
    }

    public Future<UndefOr<Tab>> duplicate(int tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.duplicate(tabId, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$6;

            public final Promise<UndefOr<Tab>> apply(UndefOr<Tab> tab) {
                return this.promise$6.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, tab){
                    public static final long serialVersionUID = 0L;
                    private final UndefOr tab$4;

                    public final UndefOr<Tab> apply() {
                        return this.tab$4;
                    }
                    {
                        this.tab$4 = tab$4;
                    }
                }));
            }
            {
                this.promise$6 = promise$6;
            }
        })));
        return promise.future();
    }

    public Future<Array<Tab>> query(TabQuery queryInfo) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.query(queryInfo, Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$7;

            public final Promise<Array<Tab>> apply(Array<Tab> tabs) {
                return this.promise$7.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, tabs){
                    public static final long serialVersionUID = 0L;
                    private final Array tabs$1;

                    public final Array<Tab> apply() {
                        return this.tabs$1;
                    }
                    {
                        this.tabs$1 = tabs$1;
                    }
                }));
            }
            {
                this.promise$7 = promise$7;
            }
        }));
        return promise.future();
    }

    public Future<Window> highlight(HighlightInfo highlightInfo) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.highlight(highlightInfo, Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$8;

            public final Promise<Window> apply(Window window) {
                return this.promise$8.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, window){
                    public static final long serialVersionUID = 0L;
                    private final Window window$1;

                    public final Window apply() {
                        return this.window$1;
                    }
                    {
                        this.window$1 = window$1;
                    }
                }));
            }
            {
                this.promise$8 = promise$8;
            }
        }));
        return promise.future();
    }

    public Future<UndefOr<Tab>> update(UndefOr<Object> tabId, UpdateProperties updateProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.update(tabId, updateProperties, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$9;

            public final Promise<UndefOr<Tab>> apply(UndefOr<Tab> tabs) {
                return this.promise$9.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, tabs){
                    public static final long serialVersionUID = 0L;
                    private final UndefOr tabs$2;

                    public final UndefOr<Tab> apply() {
                        return this.tabs$2;
                    }
                    {
                        this.tabs$2 = tabs$2;
                    }
                }));
            }
            {
                this.promise$9 = promise$9;
            }
        })));
        return promise.future();
    }

    public UndefOr<Object> update$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<Array<Tab>> move(Array<Object> tabIds, MoveProperties moveProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.move((Any)tabIds, moveProperties, (UndefOr<Function1<.bar<Tab, Array<Tab>>, ?>>)UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$10;

            public final Promise<Array<Tab>> apply(.bar<Tab, Array<Tab>> tabs) {
                return this.promise$10.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, tabs){
                    public static final long serialVersionUID = 0L;
                    private final .bar tabs$3;

                    public final Array<Tab> apply() {
                        return this.tabs$3 instanceof Array ? (Array)this.tabs$3 : Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tab[]{(Tab)this.tabs$3}));
                    }
                    {
                        this.tabs$3 = tabs$3;
                    }
                }));
            }
            {
                this.promise$10 = promise$10;
            }
        })));
        return promise.future();
    }

    public Future<BoxedUnit> reload(UndefOr<Object> tabId, ReloadProperties reloadProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.reload(tabId, reloadProperties, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction0((scala.Function0)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$11;

            public final Promise<BoxedUnit> apply() {
                return this.promise$11.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                }));
            }
            {
                this.promise$11 = promise$11;
            }
        })));
        return promise.future();
    }

    public UndefOr<Object> reload$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> remove(Array<Object> tabIds) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.remove((Any)tabIds, (UndefOr<Function0<?>>)UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction0((scala.Function0)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$12;

            public final Promise<BoxedUnit> apply() {
                return this.promise$12.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                }));
            }
            {
                this.promise$12 = promise$12;
            }
        })));
        return promise.future();
    }

    public Future<String> detectLanguage(UndefOr<Object> tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.detectLanguage(tabId, Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$13;

            public final Promise<String> apply(String language) {
                return this.promise$13.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, language){
                    public static final long serialVersionUID = 0L;
                    private final String language$1;

                    public final String apply() {
                        return this.language$1;
                    }
                    {
                        this.language$1 = language$1;
                    }
                }));
            }
            {
                this.promise$13 = promise$13;
            }
        }));
        return promise.future();
    }

    public UndefOr<Object> detectLanguage$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<String> captureVisibleTab(UndefOr<Object> windowId, UndefOr<CaptureOptions> options) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.captureVisibleTab(windowId, options, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$14;

            public final Promise<String> apply(String dataUrl) {
                return this.promise$14.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, dataUrl){
                    public static final long serialVersionUID = 0L;
                    private final String dataUrl$1;

                    public final String apply() {
                        return this.dataUrl$1;
                    }
                    {
                        this.dataUrl$1 = dataUrl$1;
                    }
                }));
            }
            {
                this.promise$14 = promise$14;
            }
        })));
        return promise.future();
    }

    public UndefOr<Object> captureVisibleTab$default$1() {
        return package$.MODULE$.undefined();
    }

    public UndefOr<CaptureOptions> captureVisibleTab$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<UndefOr<Array<Any>>> executeScript(UndefOr<Object> tabId, CodeInjectionOptions details) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.executeScript(tabId, details, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$15;

            public final Promise<UndefOr<Array<Any>>> apply(UndefOr<Array<Any>> result) {
                return this.promise$15.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, result){
                    public static final long serialVersionUID = 0L;
                    private final UndefOr result$1;

                    public final UndefOr<Array<Any>> apply() {
                        return this.result$1;
                    }
                    {
                        this.result$1 = result$1;
                    }
                }));
            }
            {
                this.promise$15 = promise$15;
            }
        })));
        return promise.future();
    }

    public UndefOr<Object> executeScript$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> insertCSS(UndefOr<Object> tabId, CodeInjectionOptions details) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.insertCSS(tabId, details, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction0((scala.Function0)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$16;

            public final Promise<BoxedUnit> apply() {
                return this.promise$16.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                }));
            }
            {
                this.promise$16 = promise$16;
            }
        })));
        return promise.future();
    }

    public UndefOr<Object> insertCSS$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> setZoom(UndefOr<Object> tabId, double zoomFactor) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.setZoom(tabId, zoomFactor, UndefOr$.MODULE$.any2undefOrA((Object)Any$.MODULE$.fromFunction0((scala.Function0)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$17;

            public final Promise<BoxedUnit> apply() {
                return this.promise$17.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                }));
            }
            {
                this.promise$17 = promise$17;
            }
        })));
        return promise.future();
    }

    public UndefOr<Object> setZoom$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<Object> getZoom(UndefOr<Object> tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getZoom(tabId, Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$18;

            public final Promise<Object> apply(double zoomFactor) {
                return this.promise$18.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, zoomFactor){
                    public static final long serialVersionUID = 0L;
                    private final double zoomFactor$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.zoomFactor$1;
                    }
                    {
                        this.zoomFactor$1 = zoomFactor$1;
                    }
                }));
            }
            {
                this.promise$18 = promise$18;
            }
        }));
        return promise.future();
    }

    public UndefOr<Object> getZoom$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> setZoomSettings(UndefOr<Object> tabId, ZoomSettings zoomSettings) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.setZoomSettings(tabId, zoomSettings, Any$.MODULE$.fromFunction0((scala.Function0)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$19;

            public final Promise<BoxedUnit> apply() {
                return this.promise$19.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                }));
            }
            {
                this.promise$19 = promise$19;
            }
        }));
        return promise.future();
    }

    public UndefOr<Object> setZoomSettings$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<ZoomSettings> getZoomSettings(UndefOr<Object> tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getZoomSettings(tabId, Any$.MODULE$.fromFunction1((scala.Function1)new Serializable(promise){
            public static final long serialVersionUID = 0L;
            private final Promise promise$20;

            public final Promise<ZoomSettings> apply(ZoomSettings zoomSettings) {
                return this.promise$20.complete(ErrorHandling$.MODULE$.lastErrorOrValue(new Serializable(this, zoomSettings){
                    public static final long serialVersionUID = 0L;
                    private final ZoomSettings zoomSettings$1;

                    public final ZoomSettings apply() {
                        return this.zoomSettings$1;
                    }
                    {
                        this.zoomSettings$1 = zoomSettings$1;
                    }
                }));
            }
            {
                this.promise$20 = promise$20;
            }
        }));
        return promise.future();
    }

    public UndefOr<Object> getZoomSettings$default$1() {
        return package$.MODULE$.undefined();
    }

    private Tabs$() {
        MODULE$ = this;
        this.requiredPermissions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Permission.API[]{Permission$API$.MODULE$.Tabs()}));
        this.onCreated = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onCreated());
        this.onUpdated = EventSourceImplicits$.MODULE$.eventAsEventSource3(chrome.tabs.bindings.Tabs$.MODULE$.onUpdated());
        this.onMoved = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onMoved());
        this.onActivated = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onActivated());
        this.onHighlighted = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onHighlighted());
        this.onDetached = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onDetached());
        this.onAttached = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onAttached());
        this.onRemoved = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onRemoved());
        this.onReplaced = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onReplaced());
        this.onZoomChange = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onZoomChange());
    }
}

