/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.assertions;

import eu.luminis.jmeter.wssampler.BinaryUtils;
import java.util.Arrays;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedAssertion;

public class BinaryContentAssertion
extends AbstractScopedAssertion
implements Assertion {
    public AssertionResult getResult(SampleResult sampleResult) {
        byte[] responseData = sampleResult.getResponseData();
        byte[] comparisonValue = BinaryUtils.parseBinaryString(this.getComparisonValue());
        AssertionResult result = new AssertionResult(this.getName());
        switch (this.getComparisonType()) {
            case Equals: {
                boolean equal = Arrays.equals(responseData, comparisonValue);
                result.setFailure(!equal);
                if (equal) break;
                result.setFailureMessage("Response expected to equal " + BinaryUtils.formatBinary(comparisonValue) + "\nResponse was: " + BinaryUtils.formatBinary(responseData));
                break;
            }
            case Contains: {
                boolean contains = BinaryUtils.contains(responseData, comparisonValue);
                result.setFailure(!contains);
                if (contains) break;
                result.setFailureMessage("Response expected to contain " + BinaryUtils.formatBinary(comparisonValue) + "\nResponse was: " + BinaryUtils.formatBinary(responseData));
                break;
            }
            case NotEquals: {
                boolean equal = Arrays.equals(responseData, comparisonValue);
                result.setFailure(equal);
                if (!equal) break;
                result.setFailureMessage("Response expected not to equal " + BinaryUtils.formatBinary(comparisonValue) + "\nResponse was: " + BinaryUtils.formatBinary(responseData));
                break;
            }
            case NotContains: {
                boolean contains = BinaryUtils.contains(responseData, comparisonValue);
                result.setFailure(contains);
                if (!contains) break;
                result.setFailureMessage("Response expected not to contain " + BinaryUtils.formatBinary(comparisonValue) + "\nResponse was: " + BinaryUtils.formatBinary(responseData));
                break;
            }
            case StartsWith: {
                boolean startsWith;
                boolean bl = startsWith = comparisonValue.length <= responseData.length && Arrays.equals(comparisonValue, Arrays.copyOf(responseData, comparisonValue.length));
                if (!startsWith) {
                    result.setFailureMessage("Response expected to start with " + BinaryUtils.formatBinary(comparisonValue) + "\nResponse was: " + BinaryUtils.formatBinary(responseData));
                }
                result.setFailure(!startsWith);
                break;
            }
            case NotStartsWith: {
                boolean startsWith;
                boolean bl = startsWith = comparisonValue.length <= responseData.length && Arrays.equals(comparisonValue, Arrays.copyOf(responseData, comparisonValue.length));
                if (startsWith) {
                    result.setFailureMessage("Response expected not to start with " + BinaryUtils.formatBinary(comparisonValue) + "\nResponse was: " + BinaryUtils.formatBinary(responseData));
                }
                result.setFailure(startsWith);
                break;
            }
            default: {
                throw new RuntimeException("Program error");
            }
        }
        return result;
    }

    public String getComparisonValue() {
        return this.getPropertyAsString("compareValue");
    }

    public void setComparisonValue(String comparisonValue) {
        this.setProperty("compareValue", comparisonValue);
    }

    public ComparisonType getComparisonType() {
        String rawValue = this.getPropertyAsString("comparisonType");
        if (rawValue.trim().length() > 0) {
            return ComparisonType.valueOf(rawValue);
        }
        return ComparisonType.Contains;
    }

    public void setComparisonType(ComparisonType comparisonType) {
        this.setProperty("comparisonType", comparisonType.toString());
    }

    public static enum ComparisonType {
        Equals,
        Contains,
        StartsWith,
        NotEquals,
        NotContains,
        NotStartsWith;

    }
}

