/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.visualizers;

import eu.luminis.jmeter.wssampler.BinaryUtils;
import java.awt.Font;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;

public class RenderAsBinary
extends SamplerResultTab
implements ResultRenderer {
    private int maxDisplaySize = JMeterUtils.getPropDefault((String)"view.results.tree.max_binary_size", (int)-1);

    public RenderAsBinary() {
        if (this.maxDisplaySize == -1) {
            this.maxDisplaySize = 0x100000;
        } else if (this.maxDisplaySize < 64) {
            this.maxDisplaySize = 64;
        }
    }

    public void renderResult(SampleResult sampleResult) {
        Font oldFont = this.results.getFont();
        this.results.setFont(new Font("Monospaced", 0, oldFont.getSize()));
        this.results.setContentType("text/plain");
        byte[] responseData = sampleResult.getResponseData();
        if (responseData.length > this.maxDisplaySize) {
            this.results.setText("Binary response is too large to display; showing first " + this.maxDisplaySize + " bytes.\n" + BinaryUtils.formatBinaryInTable(responseData, this.maxDisplaySize, 16, true, true));
        } else {
            this.results.setText(BinaryUtils.formatBinaryInTable(responseData, 16, true, true));
        }
        this.results.setCaretPosition(0);
        this.resultsScrollPane.setViewportView(this.results);
    }

    public void renderImage(SampleResult sampleResult) {
        this.renderResult(sampleResult);
    }

    public String toString() {
        return "Binary";
    }
}

